/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import mekanism.api.MekanismIMC;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.listener.ConfigBasedCachedLongSupplier;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.Version;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.recipe.ClearConfigurationRecipe;
import mekanism.common.registries.MekanismGases;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorCache;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.content.fusion.FusionReactorCache;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.content.fusion.FusionReactorValidator;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.content.turbine.TurbineValidator;
import mekanism.generators.common.network.GeneratorsPacketHandler;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsBuilders;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.registries.GeneratorsCreativeTabs;
import mekanism.generators.common.registries.GeneratorsDataComponents;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.registries.GeneratorsGases;
import mekanism.generators.common.registries.GeneratorsItems;
import mekanism.generators.common.registries.GeneratorsModules;
import mekanism.generators.common.registries.GeneratorsSounds;
import mekanism.generators.common.registries.GeneratorsTileEntityTypes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;

@Mod(value="mekanismgenerators")
public class MekanismGenerators
implements IModModule {
    public static final String MODID = "mekanismgenerators";
    private static final ConfigBasedCachedLongSupplier ETHENE_ENERGY_DENSITY = new ConfigBasedCachedLongSupplier(() -> {
        long bioGeneration = MekanismGeneratorsConfig.generators.bioGeneration.get();
        double etheneDensity = MekanismGeneratorsConfig.generators.etheneDensityMultiplier.get();
        long energy = MathUtils.clampToLong((double)((double)MathUtils.multiplyClamped((long)bioGeneration, (long)2L) * etheneDensity));
        return energy + MekanismConfig.general.FROM_H2.get();
    }, new CachedValue[]{MekanismConfig.general.FROM_H2, MekanismGeneratorsConfig.generators.bioGeneration, MekanismGeneratorsConfig.generators.etheneDensityMultiplier});
    public static MekanismGenerators instance;
    public final Version versionNumber;
    private final GeneratorsPacketHandler packetHandler;
    public static final MultiblockManager<TurbineMultiblockData> turbineManager;
    public static final MultiblockManager<FissionReactorMultiblockData> fissionReactorManager;
    public static final MultiblockManager<FusionReactorMultiblockData> fusionReactorManager;

    public MekanismGenerators(ModContainer modContainer, IEventBus modEventBus) {
        instance = this;
        Mekanism.addModule((IModModule)instance);
        this.versionNumber = new Version(modContainer);
        MekanismGeneratorsConfig.registerConfigs(modContainer);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(MekanismGeneratorsConfig::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        GeneratorsDataComponents.DATA_COMPONENTS.register(modEventBus);
        GeneratorsItems.ITEMS.register(modEventBus);
        GeneratorsBlocks.BLOCKS.register(modEventBus);
        GeneratorsFluids.FLUIDS.register(modEventBus);
        GeneratorsCreativeTabs.CREATIVE_TABS.register(modEventBus);
        GeneratorsSounds.SOUND_EVENTS.register(modEventBus);
        GeneratorsContainerTypes.CONTAINER_TYPES.register(modEventBus);
        GeneratorsTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        GeneratorsGases.GASES.register(modEventBus);
        GeneratorsModules.MODULES.register(modEventBus);
        this.packetHandler = new GeneratorsPacketHandler(modEventBus, this.versionNumber);
    }

    public static GeneratorsPacketHandler packetHandler() {
        return MekanismGenerators.instance.packetHandler;
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((Gas)MekanismGases.ETHENE.get()).addAttribute((ChemicalAttribute)new GasAttributes.Fuel((IntSupplier)MekanismGeneratorsConfig.generators.etheneBurnTicks, (LongSupplier)ETHENE_ENERGY_DENSITY));
            GeneratorsFluids.FLUIDS.registerBucketDispenserBehavior();
            BuildCommand.register((String)"turbine", (ILangEntry)GeneratorsLang.TURBINE, (StructureBuilder)new GeneratorsBuilders.TurbineBuilder());
            BuildCommand.register((String)"fission", (ILangEntry)GeneratorsLang.FISSION_REACTOR, (StructureBuilder)new GeneratorsBuilders.FissionReactorBuilder());
            BuildCommand.register((String)"fusion", (ILangEntry)GeneratorsLang.FUSION_REACTOR, (StructureBuilder)new GeneratorsBuilders.FusionReactorBuilder());
            ClearConfigurationRecipe.addAttachments((Holder[])new Holder[]{GeneratorsDataComponents.FISSION_LOGIC_TYPE, GeneratorsDataComponents.FUSION_LOGIC_TYPE, GeneratorsDataComponents.ACTIVE_COOLED});
        });
        Mekanism.logger.info("Loaded 'Mekanism: Generators' module.");
    }

    private void imcQueue(InterModEnqueueEvent event) {
        MekanismIMC.addMekaSuitHelmetModules((IModuleDataProvider[])new IModuleDataProvider[]{GeneratorsModules.SOLAR_RECHARGING_UNIT});
        MekanismIMC.addMekaSuitPantsModules((IModuleDataProvider[])new IModuleDataProvider[]{GeneratorsModules.GEOTHERMAL_GENERATOR_UNIT});
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void resetClient() {
        TurbineMultiblockData.clientRotationMap.clear();
    }

    static {
        turbineManager = new MultiblockManager("industrialTurbine", TurbineCache::new, TurbineValidator::new);
        fissionReactorManager = new MultiblockManager("fissionReactor", FissionReactorCache::new, FissionReactorValidator::new);
        fusionReactorManager = new MultiblockManager("fusionReactor", FusionReactorCache::new, FusionReactorValidator::new);
    }
}

