/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.slot;

import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidFuelInventorySlot
extends FluidInventorySlot {
    private final IntFunction<@NotNull FluidStack> fuelCreator;
    private final ToIntFunction<@NotNull ItemStack> fuelValue;

    public static FluidFuelInventorySlot forFuel(IExtendedFluidTank fluidTank, ToIntFunction<@NotNull ItemStack> fuelValue, IntFunction<@NotNull FluidStack> fuelCreator, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(fuelCreator, "Fuel fluid stack creator cannot be null");
        Objects.requireNonNull(fuelValue, "Fuel value calculator cannot be null");
        Predicate fillPredicate = FluidInventorySlot.getFillPredicate((IExtendedFluidTank)fluidTank);
        return new FluidFuelInventorySlot(fluidTank, fuelValue, fuelCreator, stack -> {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)Capabilities.FLUID.getCapability(stack);
            if (fluidHandlerItem != null) {
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    if (!fluidTank.isFluidValid(fluidHandlerItem.getFluidInTank(tank))) continue;
                    return false;
                }
            }
            return fuelValue.applyAsInt((ItemStack)stack) == 0;
        }, stack -> fuelValue.applyAsInt((ItemStack)stack) > 0 || fillPredicate.test(stack), listener, x, y);
    }

    private FluidFuelInventorySlot(IExtendedFluidTank fluidTank, ToIntFunction<@NotNull ItemStack> fuelValue, IntFunction<@NotNull FluidStack> fuelCreator, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(fluidTank, canExtract, canInsert, listener, x, y);
        this.fuelCreator = fuelCreator;
        this.fuelValue = fuelValue;
    }

    public void fillOrBurn() {
        int fuel;
        int needed;
        if (!this.isEmpty() && (needed = this.fluidTank.getNeeded()) > 0 && !this.fillTank() && (fuel = this.fuelValue.applyAsInt(this.current)) > 0 && fuel <= needed) {
            boolean hasContainer = this.current.hasCraftingRemainingItem();
            if (hasContainer && this.current.getCount() > 1) {
                return;
            }
            this.fluidTank.insert(this.fuelCreator.apply(fuel), Action.EXECUTE, AutomationType.INTERNAL);
            if (hasContainer) {
                this.setStack(this.current.getCraftingRemainingItem());
            } else {
                MekanismUtils.logMismatchedStackSize((long)this.shrinkStack(1, Action.EXECUTE), (long)1L);
            }
        }
    }
}

