/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityBioGenerator
extends TileEntityGenerator {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getBioFuel", "getBioFuelCapacity", "getBioFuelNeeded", "getBioFuelFilledPercentage"}, docPlaceholder="biofuel tank")
    public BasicFluidTank bioFuelTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel slot")
    FluidFuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item")
    EnergyInventorySlot energySlot;
    private float lastFluidScale;

    public TileEntityBioGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.BIO_GENERATOR, pos, state, (LongSupplier)MekanismGeneratorsConfig.generators.bioGeneration);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityBioGenerator)this).getDirection());
        this.bioFuelTank = VariableCapacityFluidTank.input((IntSupplier)MekanismGeneratorsConfig.generators.bioTankCapacity, fluidStack -> fluidStack.is(GeneratorTags.Fluids.BIOETHANOL), (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.bioFuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityBioGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.bioFuelTank, stack -> stack.is(MekanismTags.Items.FUELS_BIO) ? 200 : (stack.is(MekanismTags.Items.FUELS_BLOCK_BIO) ? 1800 : 0), arg_0 -> GeneratorsFluids.BIOETHANOL.getFluidStack(arg_0), listener, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        if (this.canFunction() && !this.bioFuelTank.isEmpty() && this.getEnergyContainer().insert(MekanismGeneratorsConfig.generators.bioGeneration.get(), Action.SIMULATE, AutomationType.INTERNAL) == 0L) {
            this.setActive(true);
            MekanismUtils.logMismatchedStackSize((long)this.bioFuelTank.shrinkStack(1, Action.EXECUTE), (long)1L);
            this.getEnergyContainer().insert(MekanismGeneratorsConfig.generators.bioGeneration.get(), Action.EXECUTE, AutomationType.INTERNAL);
            float fluidScale = MekanismUtils.getScale((float)this.lastFluidScale, (IExtendedFluidTank)this.bioFuelTank);
            if (MekanismUtils.scaleChanged((float)fluidScale, (float)this.lastFluidScale)) {
                this.lastFluidScale = fluidScale;
                sendUpdatePacket = true;
            }
        } else {
            this.setActive(false);
        }
        return sendUpdatePacket;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("fluid", (Tag)this.bioFuelTank.serializeNBT(provider));
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent((CompoundTag)tag, (String)"fluid", nbt -> this.bioFuelTank.deserializeNBT(provider, nbt));
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.bioFuelTank.getFluidAmount(), (long)this.bioFuelTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    @Override
    long getProductionRate() {
        return this.getActive() ? MekanismGeneratorsConfig.generators.bioGeneration.get() : 0L;
    }
}

