/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.chemical.variable.VariableCapacityChemicalTankBuilder;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityGasGenerator
extends TileEntityGenerator {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getFuel", "getFuelCapacity", "getFuelNeeded", "getFuelFilledPercentage"}, docPlaceholder="fuel tank")
    public VariableCapacityChemicalTankBuilder.VariableCapacityGasTank fuelTank;
    private long burnTicks;
    private int maxBurnTicks;
    private long generationRate = 0L;
    private double gasUsedLastTick;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel item slot")
    GasInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;

    public TileEntityGasGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.GAS_BURNING_GENERATOR, pos, state, (LongSupplier)MekanismConfig.general.FROM_H2);
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(() -> ((TileEntityGasGenerator)this).getDirection());
        this.fuelTank = new FuelTank(listener);
        builder.addTank((IChemicalTank)this.fuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityGasGenerator)this).getDirection());
        this.fuelSlot = GasInventorySlot.fill((IGasTank)this.fuelTank, (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.fuelSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillTank();
        if (!this.fuelTank.isEmpty() && this.canFunction() && this.getEnergyContainer().insert(this.generationRate, Action.SIMULATE, AutomationType.INTERNAL) == 0L) {
            GasAttributes.Fuel fuel;
            this.setActive(true);
            if (!this.fuelTank.isEmpty() && (fuel = (GasAttributes.Fuel)((Gas)this.fuelTank.getType()).get(GasAttributes.Fuel.class)) != null) {
                this.maxBurnTicks = Math.max(1, fuel.getBurnTicks());
                this.generationRate = fuel.getEnergyPerTick();
            }
            long toUse = this.getToUse();
            long toUseGeneration = MathUtils.multiplyClamped((long)this.generationRate, (long)toUse);
            this.updateMaxOutputRaw(Math.max(MekanismConfig.general.FROM_H2.get(), toUseGeneration));
            long total = this.burnTicks + this.fuelTank.getStored() * (long)this.maxBurnTicks;
            total -= toUse;
            this.getEnergyContainer().insert(toUseGeneration, Action.EXECUTE, AutomationType.INTERNAL);
            if (!this.fuelTank.isEmpty()) {
                this.fuelTank.setStack((ChemicalStack)((GasStack)this.fuelTank.getStack()).copyWithAmount(total / (long)this.maxBurnTicks));
            }
            this.burnTicks = total % (long)this.maxBurnTicks;
            this.gasUsedLastTick = (double)toUse / (double)this.maxBurnTicks;
        } else {
            if (this.fuelTank.isEmpty() && this.burnTicks == 0L) {
                this.reset();
            }
            this.gasUsedLastTick = 0.0;
            this.setActive(false);
        }
        return sendUpdatePacket;
    }

    private void reset() {
        this.burnTicks = 0L;
        this.maxBurnTicks = 0;
        this.generationRate = 0L;
        this.updateMaxOutputRaw(MekanismConfig.general.FROM_H2.get());
    }

    private long getToUse() {
        if (this.generationRate == 0L || this.fuelTank.isEmpty()) {
            return 0L;
        }
        long max = (long)Math.ceil(256.0 * ((double)this.fuelTank.getStored() / (double)this.fuelTank.getCapacity()));
        max = Math.min((long)this.maxBurnTicks * this.fuelTank.getStored() + this.burnTicks, max);
        max = Math.min(MathUtils.clampToLong((double)((double)this.getEnergyContainer().getNeeded() / (double)this.generationRate)), max);
        return max;
    }

    public long getGenerationRate() {
        return this.generationRate;
    }

    @ComputerMethod(nameOverride="getBurnRate")
    public double getUsed() {
        return (double)Math.round(this.gasUsedLastTick * 100.0) / 100.0;
    }

    public int getMaxBurnTicks() {
        return this.maxBurnTicks;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.GAS;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableLong.create(this::getGenerationRate, value -> {
            this.generationRate = value;
        }));
        container.track(this.syncableMaxOutput());
        container.track((ISyncableData)SyncableDouble.create(this::getUsed, value -> {
            this.gasUsedLastTick = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getMaxBurnTicks, value -> {
            this.maxBurnTicks = value;
        }));
    }

    @Override
    long getProductionRate() {
        return MathUtils.clampToLong((double)((double)this.getGenerationRate() * this.getUsed() * (double)this.getMaxBurnTicks()));
    }

    private class FuelTank
    extends VariableCapacityChemicalTankBuilder.VariableCapacityGasTank {
        protected FuelTank(IContentsListener listener) {
            super((LongSupplier)MekanismGeneratorsConfig.generators.gbgTankCapacity, ChemicalTankBuilder.GAS.notExternal, ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> gas.has(GasAttributes.Fuel.class), null, listener);
        }

        public void setStack(@NotNull GasStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStack((ChemicalStack)stack);
            this.recheckOutput(stack, wasEmpty);
        }

        public void setStackUnchecked(@NotNull GasStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStackUnchecked((ChemicalStack)stack);
            this.recheckOutput(stack, wasEmpty);
        }

        private void recheckOutput(@NotNull GasStack stack, boolean wasEmpty) {
            GasAttributes.Fuel fuel;
            if (wasEmpty && !stack.isEmpty() && (fuel = (GasAttributes.Fuel)((Gas)this.getType()).get(GasAttributes.Fuel.class)) != null) {
                TileEntityGasGenerator.this.updateMaxOutputRaw(fuel.getEnergyPerTick());
            }
        }
    }
}

