/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.List;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    private static final float SPEED = 32.0f;
    private static final RelativeSide[] ENERGY_SIDES = new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    private double angle;
    private double currentMultiplier = 0.0;
    private boolean isBlacklistDimension;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;

    public TileEntityWindGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.WIND_GENERATOR, pos, state, (LongSupplier)MekanismGeneratorsConfig.generators.windGenerationMax);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityWindGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return ENERGY_SIDES;
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        if (this.isBlacklistDimension) {
            return sendUpdatePacket;
        }
        if (this.ticker % 20 == 0) {
            this.currentMultiplier = this.getMultiplier();
            this.setActive(this.canFunction() && this.currentMultiplier != 0.0);
        }
        if (this.currentMultiplier != 0.0 && this.canFunction() && this.getEnergyContainer().getNeeded() > 0L) {
            this.getEnergyContainer().insert(this.getCurrentGeneration(), Action.EXECUTE, AutomationType.INTERNAL);
        }
        return sendUpdatePacket;
    }

    public long getCurrentGeneration() {
        return MathUtils.clampToLong((double)((double)MekanismGeneratorsConfig.generators.windGenerationMin.get() * this.currentMultiplier));
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            this.angle = (this.angle + (double)this.getHeightSpeedRatio()) % 360.0;
        }
    }

    public float getHeightSpeedRatio() {
        int height = this.getBlockPos().getY() + 4;
        if (this.level == null) {
            return 32.0f * (float)height / 384.0f;
        }
        int minBuildHeight = this.level.getMinBuildHeight();
        return 32.0f * (float)(height -= minBuildHeight) / (float)(this.level.getMaxBuildHeight() - minBuildHeight);
    }

    private double getMultiplier() {
        BlockPos top;
        if (this.level != null && this.level.getFluidState(top = this.getBlockPos().above(4)).isEmpty() && this.level.canSeeSky(top)) {
            int minY = Math.max(MekanismGeneratorsConfig.generators.windGenerationMinY.get(), this.level.getMinBuildHeight());
            int maxY = Math.min(MekanismGeneratorsConfig.generators.windGenerationMaxY.get(), this.level.dimensionType().logicalHeight());
            int clampedY = Math.min(maxY, Math.max(minY, top.getY()));
            long minG = MekanismGeneratorsConfig.generators.windGenerationMin.get();
            long maxG = MekanismGeneratorsConfig.generators.windGenerationMax.get();
            double slope = (double)(maxG - minG) / (double)(maxY - minY);
            double toGen = (double)minG + slope * (double)(clampedY - minY);
            return toGen / (double)minG;
        }
        return 0.0;
    }

    public void setLevel(@NotNull Level world) {
        super.setLevel(world);
        this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(world.dimension().location());
        if (this.isBlacklistDimension) {
            this.setActive(false);
        }
    }

    public double getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    @ComputerMethod(nameOverride="isBlacklistedDimension")
    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    public SoundSource getSoundCategory() {
        return SoundSource.WEATHER;
    }

    public BlockPos getSoundPos() {
        return super.getSoundPos().above(4);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableDouble.create(this::getCurrentMultiplier, value -> {
            this.currentMultiplier = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isBlacklistDimension, value -> {
            this.isBlacklistDimension = value;
        }));
    }

    @Override
    long getProductionRate() {
        return this.getActive() ? this.getCurrentGeneration() : 0L;
    }
}

