/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityFissionReactorCasing
extends TileEntityMultiblock<FissionReactorMultiblockData> {
    private boolean handleSound;
    private boolean prevBurning;

    public TileEntityFissionReactorCasing(BlockPos pos, BlockState state) {
        super(GeneratorsBlocks.FISSION_REACTOR_CASING, pos, state);
    }

    public TileEntityFissionReactorCasing(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    protected boolean onUpdateServer(FissionReactorMultiblockData multiblock) {
        boolean burning;
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean bl = burning = multiblock.isFormed() && multiblock.handlesSound(this) && multiblock.isBurning();
        if (burning != this.prevBurning) {
            this.prevBurning = burning;
            needsPacket = true;
        }
        return needsPacket;
    }

    public double getBoilEfficiency() {
        return (double)Math.round(((FissionReactorMultiblockData)this.getMultiblock()).getBoilEfficiency() * 1000.0) / 1000.0;
    }

    public void setReactorActive(boolean active) {
        ((FissionReactorMultiblockData)this.getMultiblock()).setActive(active);
    }

    public Component getDamageString() {
        return MekanismLang.GENERIC_PERCENT.translate(new Object[]{((FissionReactorMultiblockData)this.getMultiblock()).getDamagePercent()});
    }

    public EnumColor getDamageColor() {
        double damage = ((FissionReactorMultiblockData)this.getMultiblock()).reactorDamage / 100.0;
        return damage < 0.25 ? EnumColor.BRIGHT_GREEN : (damage < 0.5 ? EnumColor.YELLOW : (damage < 0.75 ? EnumColor.ORANGE : EnumColor.DARK_RED));
    }

    public EnumColor getTempColor() {
        double temp = ((FissionReactorMultiblockData)this.getMultiblock()).heatCapacitor.getTemperature();
        return temp < 600.0 ? EnumColor.BRIGHT_GREEN : (temp < 1000.0 ? EnumColor.YELLOW : (temp < 1200.0 ? EnumColor.ORANGE : (temp < 1600.0 ? EnumColor.RED : EnumColor.DARK_RED)));
    }

    public void setRateLimitFromPacket(double rate) {
        ((FissionReactorMultiblockData)this.getMultiblock()).setRateLimit(rate);
    }

    public FissionReactorMultiblockData createMultiblock() {
        return new FissionReactorMultiblockData(this);
    }

    public MultiblockManager<FissionReactorMultiblockData> getManager() {
        return MekanismGenerators.fissionReactorManager;
    }

    protected boolean canPlaySound() {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        return multiblock.isFormed() && multiblock.isBurning() && this.handleSound;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        updateTag.putBoolean("handle_sound", multiblock.isFormed() && multiblock.handlesSound(this));
        if (multiblock.isFormed()) {
            updateTag.putDouble("burning", multiblock.lastBurnRate);
        }
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        super.handleUpdateTag(tag, provider);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"handle_sound", value -> {
            this.handleSound = value;
        });
        if (multiblock.isFormed()) {
            NBTUtils.setDoubleIfPresent((CompoundTag)tag, (String)"burning", value -> {
                multiblock.lastBurnRate = value;
            });
        }
    }
}

