/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityTurbineValve
extends TileEntityTurbineCasing {
    private final Map<Direction, BlockEnergyCapabilityCache> energyCapabilityCaches = new EnumMap<Direction, BlockEnergyCapabilityCache>(Direction.class);

    public TileEntityTurbineValve(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.TURBINE_VALVE, pos, state);
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return side -> ((TurbineMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return side -> ((TurbineMultiblockData)this.getMultiblock()).getEnergyContainers(side);
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.GAS || type == ContainerType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    public void addEnergyTargetCapability(List<BlockEnergyCapabilityCache> outputTargets, Direction side) {
        BlockEnergyCapabilityCache cache = this.energyCapabilityCaches.get(side);
        if (cache == null) {
            cache = BlockEnergyCapabilityCache.create((ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Direction)side.getOpposite());
            this.energyCapabilityCaches.put(side, cache);
        }
        outputTargets.add(cache);
    }

    public int getRedstoneLevel() {
        return ((TurbineMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

