/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.additions.client.model.ModelBabyCreeper;
import mekanism.additions.client.render.entity.layer.BabyCreeperChargeLayer;
import mekanism.additions.common.entity.baby.EntityBabyCreeper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RenderBabyCreeper
extends MobRenderer<EntityBabyCreeper, ModelBabyCreeper> {
    private static final ResourceLocation CREEPER_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper.png");

    public RenderBabyCreeper(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelBabyCreeper(context.getModelSet().bakeLayer(ModelBabyCreeper.CREEPER_LAYER)), 0.5f);
        this.addLayer((RenderLayer)new BabyCreeperChargeLayer((RenderLayerParent<EntityBabyCreeper, ModelBabyCreeper>)this, context.getModelSet()));
    }

    protected void scale(EntityBabyCreeper creeper, PoseStack matrix, float partialTicks) {
        float f = creeper.getSwelling(partialTicks);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        matrix.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(EntityBabyCreeper creeper, float partialTicks) {
        float f = creeper.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityBabyCreeper entity) {
        return CREEPER_TEXTURES;
    }
}

