/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.voice;

import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import mekanism.additions.client.AdditionsKeyHandler;
import mekanism.additions.client.voice.VoiceClient;
import mekanism.common.Mekanism;

public class VoiceInput
extends Thread {
    private final VoiceClient voiceClient;
    private final DataLine.Info microphone;
    private TargetDataLine targetLine;

    public VoiceInput(VoiceClient client) {
        super("VoiceServer Client Input Thread");
        this.voiceClient = client;
        this.microphone = new DataLine.Info(TargetDataLine.class, this.voiceClient.getAudioFormat(), 2200);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            if (!AudioSystem.isLineSupported(this.microphone)) {
                Mekanism.logger.info("No audio system available.");
                return;
            }
            this.targetLine = (TargetDataLine)AudioSystem.getLine(this.microphone);
            this.targetLine.open(this.voiceClient.getAudioFormat(), 2200);
            this.targetLine.start();
            AudioInputStream audioInput = new AudioInputStream(this.targetLine);
            boolean doFlush = false;
            while (this.voiceClient.isRunning()) {
                if (AdditionsKeyHandler.voiceKey.isDown()) {
                    this.targetLine.flush();
                    while (this.voiceClient.isRunning() && AdditionsKeyHandler.voiceKey.isDown()) {
                        try {
                            int availableBytes = audioInput.available();
                            byte[] audioData = new byte[Math.min(availableBytes, 2200)];
                            int bytesRead = audioInput.read(audioData, 0, audioData.length);
                            if (bytesRead <= 0) continue;
                            this.voiceClient.getOutputStream().writeShort(audioData.length);
                            this.voiceClient.getOutputStream().write(audioData);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    doFlush = true;
                } else if (doFlush) {
                    try {
                        this.voiceClient.getOutputStream().flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    doFlush = false;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            audioInput.close();
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while running client input thread.", (Throwable)e);
        }
    }

    public void close() {
        if (this.targetLine != null) {
            this.targetLine.flush();
            this.targetLine.close();
        }
    }
}

