/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.block;

import mekanism.additions.common.registries.AdditionsBlockTypes;
import mekanism.api.text.EnumColor;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.prefab.BlockBase;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockGlowPanel
extends BlockBase.BlockBaseModel<BlockType>
implements IColoredBlock {
    private static final VoxelShape[] MIN_SHAPES = new VoxelShape[EnumUtils.DIRECTIONS.length];
    private final EnumColor color;

    public BlockGlowPanel(EnumColor color) {
        super(AdditionsBlockTypes.GLOW_PANEL, BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(1.0f, 6.0f));
        this.color = color;
    }

    public EnumColor getColor() {
        return this.color;
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing.getOpposite() == Attribute.getFacing((BlockState)state) && !state.canSurvive((LevelReader)world, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Direction side = Attribute.getFacing((BlockState)state);
        Direction sideOn = side.getOpposite();
        BlockPos offsetPos = pos.relative(sideOn);
        VoxelShape projected = world.getBlockState(offsetPos).getBlockSupportShape((BlockGetter)world, offsetPos).getFaceShape(side);
        return !state.is(BlockTags.LEAVES) && !Shapes.joinIsNotEmpty((VoxelShape)projected, (VoxelShape)MIN_SHAPES[sideOn.ordinal()], (BooleanOp)BooleanOp.ONLY_SECOND);
    }

    static {
        VoxelShapeUtils.setShape((VoxelShape)BlockGlowPanel.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])MIN_SHAPES, (boolean)true);
    }
}

