/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.config;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedResourceLocationListValue;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AdditionsConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedIntValue obsidianTNTDelay;
    public final CachedFloatValue obsidianTNTBlastRadius;
    public final CachedDoubleValue babyArrowDamageMultiplier;
    public final CachedBooleanValue voiceServerEnabled;
    public final CachedIntValue voicePort;
    private final Map<BabyType, SpawnConfig> spawnConfigs = new EnumMap<BabyType, SpawnConfig>(BabyType.class);

    AdditionsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Mekanism Additions Config. This config is synced between server and client.").push("additions");
        this.obsidianTNTDelay = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)builder.comment("Fuse time for Obsidian TNT.").defineInRange("obsidianTNTDelay", 100, 0, Integer.MAX_VALUE));
        this.obsidianTNTBlastRadius = CachedFloatValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)builder.comment("Radius of the explosion of Obsidian TNT.").defineInRange("obsidianTNTBlastRadius", 12.0, 0.1, 1000.0));
        this.babyArrowDamageMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)builder.comment("Damage multiplier of arrows shot by baby mobs.").defineInRange("babyArrowDamageMultiplier", 0.25, 0.1, 10.0));
        this.voiceServerEnabled = CachedBooleanValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)builder.comment("Enables the voice server for Walkie Talkies.").worldRestart().define("voiceServerEnabled", false));
        this.voicePort = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)builder.comment("TCP port for the Voice server to listen on.").defineInRange("VoicePort", 36123, 1, 65535));
        builder.comment("Config options regarding spawning of entities.").push("spawning");
        this.addBabyTypeConfig(BabyType.BOGGED, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_BOGGED, (EntityType<?>)EntityType.BOGGED);
        this.addBabyTypeConfig(BabyType.CREEPER, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_CREEPER, (EntityType<?>)EntityType.CREEPER);
        this.addBabyTypeConfig(BabyType.ENDERMAN, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_ENDERMAN, (EntityType<?>)EntityType.ENDERMAN);
        this.addBabyTypeConfig(BabyType.SKELETON, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_SKELETON, (EntityType<?>)EntityType.SKELETON);
        this.addBabyTypeConfig(BabyType.STRAY, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_STRAY, (EntityType<?>)EntityType.STRAY);
        this.addBabyTypeConfig(BabyType.WITHER_SKELETON, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_WITHER_SKELETON, (EntityType<?>)EntityType.WITHER_SKELETON);
        builder.pop(2);
        this.configSpec = builder.build();
    }

    private void addBabyTypeConfig(BabyType type, ModConfigSpec.Builder builder, Holder<EntityType<?>> entityTypeProvider, EntityType<?> parentType) {
        this.spawnConfigs.put(type, new SpawnConfig((IMekanismConfig)this, builder, "baby " + type.getSerializedName().replace('_', ' '), entityTypeProvider, parentType));
    }

    public String getFileName() {
        return "additions";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public SpawnConfig getConfig(BabyType babyType) {
        return this.spawnConfigs.get((Object)babyType);
    }

    public static class SpawnConfig {
        public final CachedBooleanValue shouldSpawn;
        public final CachedDoubleValue weightPercentage;
        public final CachedDoubleValue minSizePercentage;
        public final CachedDoubleValue maxSizePercentage;
        public final CachedDoubleValue spawnCostPerEntityPercentage;
        public final CachedDoubleValue maxSpawnCostPercentage;
        public final CachedResourceLocationListValue biomeBlackList;
        public final CachedResourceLocationListValue structureBlackList;
        public final Holder<EntityType<?>> entityType;
        public final EntityType<?> parentType;

        private SpawnConfig(IMekanismConfig config, ModConfigSpec.Builder builder, String name, Holder<EntityType<?>> entityType, EntityType<?> parentType) {
            this.entityType = entityType;
            this.parentType = parentType;
            builder.comment("Config options regarding " + name + ".").push(name.replace(" ", "-"));
            this.shouldSpawn = CachedBooleanValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Enable the spawning of " + name + ". Think baby zombies.").worldRestart().define("shouldSpawn", true));
            this.weightPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("The multiplier for weight of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("weightPercentage", 0.05, 0.0, 100.0));
            this.minSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("The multiplier for minimum group size of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("minSizePercentage", 0.5, 0.0, 100.0));
            this.maxSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("The multiplier for maximum group size of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("maxSizePercentage", 0.5, 0.0, 100.0));
            this.spawnCostPerEntityPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("The multiplier for spawn cost per entity of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("spawnCostPerEntityPercentage", 1.0, 0.0, 100.0));
            this.maxSpawnCostPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("The multiplier for max spawn cost of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("maxSpawnCostPercentage", 1.0, 0.0, 100.0));
            this.biomeBlackList = CachedResourceLocationListValue.define((IMekanismConfig)config, (ModConfigSpec.Builder)builder.comment("The list of biome ids that " + name + " will not spawn in even if the normal mob variant can spawn.").worldRestart(), (String)"biomeBlackList", (Predicate)ConstantPredicates.alwaysTrue());
            this.structureBlackList = CachedResourceLocationListValue.define((IMekanismConfig)config, (ModConfigSpec.Builder)builder.comment("The list of structure ids that " + name + " will not spawn in even if the normal mob variant can spawn.").worldRestart(), (String)"structureBlackList", arg_0 -> ((Registry)BuiltInRegistries.STRUCTURE_TYPE).containsKey(arg_0));
            builder.pop();
        }

        public MobSpawnSettings.SpawnerData getSpawner(MobSpawnSettings.SpawnerData parentEntry) {
            int weight = Mth.ceil((double)((double)parentEntry.getWeight().asInt() * this.weightPercentage.get()));
            int minSize = Mth.ceil((double)((double)parentEntry.minCount * this.minSizePercentage.get()));
            int maxSize = Mth.ceil((double)((double)parentEntry.maxCount * this.maxSizePercentage.get()));
            return new MobSpawnSettings.SpawnerData((EntityType)this.entityType.value(), weight, minSize, Math.max(minSize, maxSize));
        }

        public List<MobSpawnSettings.SpawnerData> getSpawnersToAdd(List<MobSpawnSettings.SpawnerData> monsterSpawns) {
            ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
            for (MobSpawnSettings.SpawnerData monsterSpawn : monsterSpawns) {
                if (monsterSpawn.type != this.parentType) continue;
                list.add(this.getSpawner(monsterSpawn));
            }
            return list;
        }
    }
}

