/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemBalloon
extends Item {
    private final EnumColor color;

    public ItemBalloon(EnumColor color) {
        super(new Item.Properties());
        this.color = color;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior(this.color));
    }

    public EnumColor getColor() {
        return this.color;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            boolean rightHand = MekanismUtils.isRightArm((LivingEntity)player, (InteractionHand)hand);
            Pos3D pos = new Pos3D(rightHand ? -0.4 : 0.4, 0.0, 0.3).yRot(player.yBodyRot).translate((Vec3)new Pos3D((Entity)player));
            EntityBalloon balloon = EntityBalloon.create(world, pos.x - 0.5, pos.y - 1.25, pos.z - 0.5, this.color);
            if (balloon == null) {
                return InteractionResultHolder.fail((Object)stack);
            }
            world.addFreshEntity((Entity)balloon);
            world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, (Vec3)pos);
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemBalloon) {
            ItemBalloon balloon = (ItemBalloon)item;
            return TextComponentUtil.build((Object[])new Object[]{balloon.getColor(), super.getName(stack)});
        }
        return super.getName(stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        if (player.isShiftKeyDown()) {
            BlockPos pos = context.getClickedPos();
            AABB bound = AABB.encapsulatingFullBlocks((BlockPos)pos, (BlockPos)pos.above(2));
            List balloonsNear = player.level().getEntitiesOfClass(EntityBalloon.class, bound);
            if (!balloonsNear.isEmpty()) {
                return InteractionResult.FAIL;
            }
            Level world = context.getLevel();
            if (WorldUtils.isValidReplaceableBlock((BlockGetter)world, null, (BlockPos)pos)) {
                pos = pos.below();
            }
            if (!Block.canSupportCenter((LevelReader)world, (BlockPos)pos, (Direction)Direction.UP)) {
                return InteractionResult.FAIL;
            }
            if (WorldUtils.isValidReplaceableBlock((BlockGetter)world, null, (BlockPos)pos.above()) && WorldUtils.isValidReplaceableBlock((BlockGetter)world, null, (BlockPos)pos.above(2))) {
                world.removeBlock(pos.above(), false);
                world.removeBlock(pos.above(2), false);
                if (!world.isClientSide) {
                    EntityBalloon balloon = EntityBalloon.create(world, pos, this.color);
                    if (balloon == null) {
                        return InteractionResult.FAIL;
                    }
                    world.addFreshEntity((Entity)balloon);
                    stack.shrink(1);
                    world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            Level level = player.level();
            if (!level.isClientSide) {
                AABB bound = new AABB(entity.getX() - 0.2, entity.getY() - 0.5, entity.getZ() - 0.2, entity.getX() + 0.2, entity.getY() + (double)entity.getBbHeight() + 4.0, entity.getZ() + 0.2);
                List balloonsNear = level.getEntitiesOfClass(EntityBalloon.class, bound);
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    return InteractionResult.SUCCESS;
                }
                EntityBalloon balloon = EntityBalloon.create(entity, this.color);
                if (balloon == null) {
                    return InteractionResult.FAIL;
                }
                level.addFreshEntity((Entity)balloon);
                stack.shrink(1);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, balloon.position());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static class DispenserBehavior
    extends DefaultDispenseItemBehavior {
        private final EnumColor color;

        public DispenserBehavior(EnumColor color) {
            this.color = color;
        }

        @NotNull
        public ItemStack execute(BlockSource source, @NotNull ItemStack stack) {
            Direction side = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos sourcePos = source.pos();
            BlockPos offsetPos = sourcePos.relative(side);
            List entities = source.level().getEntitiesOfClass(LivingEntity.class, new AABB(offsetPos));
            boolean latched = false;
            for (LivingEntity entity : entities) {
                AABB bound = new AABB(entity.getX() - 0.2, entity.getY() - 0.5, entity.getZ() - 0.2, entity.getX() + 0.2, entity.getY() + (double)entity.getBbHeight() + 4.0, entity.getZ() + 0.2);
                List balloonsNear = source.level().getEntitiesOfClass(EntityBalloon.class, bound);
                boolean hasBalloon = false;
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    hasBalloon = true;
                    break;
                }
                if (hasBalloon) continue;
                EntityBalloon balloon = EntityBalloon.create(entity, this.color);
                if (balloon != null) {
                    source.level().addFreshEntity((Entity)balloon);
                }
                latched = true;
            }
            if (!latched) {
                EntityBalloon balloon;
                Vec3 pos = Vec3.atLowerCornerOf((Vec3i)sourcePos).add(0.0, -0.5, 0.0);
                switch (side) {
                    case DOWN: {
                        pos = pos.add(0.0, -3.5, 0.0);
                        break;
                    }
                    case NORTH: {
                        pos = pos.add(0.0, -1.0, -0.5);
                        break;
                    }
                    case SOUTH: {
                        pos = pos.add(0.0, -1.0, 0.5);
                        break;
                    }
                    case WEST: {
                        pos = pos.add(-0.5, -1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        pos = pos.add(0.5, -1.0, 0.0);
                    }
                }
                if (!source.level().isClientSide && (balloon = EntityBalloon.create((Level)source.level(), pos.x, pos.y, pos.z, this.color)) != null) {
                    source.level().addFreshEntity((Entity)balloon);
                }
            }
            stack.shrink(1);
            return stack;
        }
    }
}

