/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.world.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.additions.common.config.AdditionsConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsStructureModifierSerializers;
import mekanism.common.Mekanism;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.world.ModifiableStructureInfo;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.common.world.StructureSettingsBuilder;

public record BabyEntitySpawnStructureModifier(BabyType babyType, AdditionsConfig.SpawnConfig spawnConfig) implements StructureModifier
{
    public BabyEntitySpawnStructureModifier(BabyType babyType) {
        this(babyType, MekanismAdditionsConfig.additions.getConfig(babyType));
    }

    public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (phase == StructureModifier.Phase.REMOVE && this.spawnConfig.shouldSpawn.get()) {
            StructureSettingsBuilder structureSettings = builder.getStructureSettings();
            StructureSettingsBuilder.StructureSpawnOverrideBuilder spawnOverrides = structureSettings.getSpawnOverrides(MobCategory.MONSTER);
            ResourceLocation structureName = BuiltInRegistries.STRUCTURE_TYPE.getKey((Object)((Structure)structure.value()).type());
            if (spawnOverrides != null && !((List)this.spawnConfig.structureBlackList.get()).contains(structureName)) {
                for (MobSpawnSettings.SpawnerData spawner : this.spawnConfig.getSpawnersToAdd(spawnOverrides.getSpawns())) {
                    spawnOverrides.addSpawn(spawner);
                    Mekanism.logger.debug("Adding spawn rate for '{}' in structure '{}', with weight: {}, minSize: {}, maxSize: {}", new Object[]{RegistryUtils.getName((EntityType)spawner.type), structureName, spawner.getWeight(), spawner.minCount, spawner.maxCount});
                }
            }
        }
    }

    public MapCodec<? extends StructureModifier> codec() {
        return (MapCodec)AdditionsStructureModifierSerializers.SPAWN_BABIES.get();
    }

    public static MapCodec<BabyEntitySpawnStructureModifier> makeCodec() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)BabyType.CODEC.fieldOf("baby_type").forGetter(BabyEntitySpawnStructureModifier::babyType)).apply((Applicative)builder, BabyEntitySpawnStructureModifier::new));
    }
}

