/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.tooltips;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class MuteTooltipSupplier
implements ImageButton.TooltipSupplier {
    private Screen screen;
    private ClientPlayerStateManager stateManager;

    public MuteTooltipSupplier(Screen screen, ClientPlayerStateManager stateManager) {
        this.screen = screen;
        this.stateManager = stateManager;
    }

    @Override
    public void onTooltip(ImageButton button, GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        if (!MuteTooltipSupplier.canMuteMic()) {
            tooltip.add(Component.translatable((String)"message.voicechat.mute.disabled_ptt").getVisualOrderText());
        } else if (this.stateManager.isMuted()) {
            tooltip.add(Component.translatable((String)"message.voicechat.mute.enabled").getVisualOrderText());
        } else {
            tooltip.add(Component.translatable((String)"message.voicechat.mute.disabled").getVisualOrderText());
        }
        guiGraphics.renderTooltip(font, tooltip, mouseX, mouseY);
    }

    public static boolean canMuteMic() {
        return VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
    }
}

