/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.EnvExecutor;
import io.github.jamalam360.jamlib.JamLibClient;
import io.github.jamalam360.jamlib.JamLibPlatform;
import io.github.jamalam360.jamlib.JarRenamingChecker;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamLib {
    public static final String MOD_ID = "jamlib";
    public static final String MOD_NAME = "JamLib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"JamLib");
    protected static final JarRenamingChecker JAR_RENAMING_CHECKER = new JarRenamingChecker();

    @ApiStatus.Internal
    public static void init() {
        LOGGER.info("Initializing JamLib on {}", (Object)JamLibPlatform.getPlatform());
        JamLib.checkForJarRenaming(JamLib.class);
        EnvExecutor.runInEnv((Dist)Dist.CLIENT, () -> () -> ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(JamLibClient::onPlayerJoin));
    }

    public static void checkForJarRenaming(Class<?> anyModClass) {
        if (!Platform.isDevelopmentEnvironment()) {
            JAR_RENAMING_CHECKER.checkJar(anyModClass);
        }
    }

    @ApiStatus.Internal
    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

