/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.sampler.AbstractSampler;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.SamplerMode;
import me.lucko.spark.common.sampler.SamplerSettings;
import me.lucko.spark.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.AsyncProfilerJob;
import me.lucko.spark.common.sampler.async.SampleCollector;
import me.lucko.spark.common.sampler.window.ProfilingWindowUtils;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.util.SparkThreadFactory;
import me.lucko.spark.common.ws.ViewerSocket;
import me.lucko.spark.proto.SparkSamplerProtos;

public class AsyncSampler
extends AbstractSampler {
    private final SampleCollector<?> sampleCollector;
    private final AsyncProfilerAccess profilerAccess;
    private final AsyncDataAggregator dataAggregator;
    private final Object[] currentJobMutex = new Object[0];
    private AsyncProfilerJob currentJob;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> socketStatisticsTask;

    public AsyncSampler(SparkPlatform platform, SamplerSettings settings, SampleCollector<?> collector) {
        super(platform, settings);
        this.sampleCollector = collector;
        this.profilerAccess = AsyncProfilerAccess.getInstance(platform);
        this.dataAggregator = new AsyncDataAggregator(settings.threadGrouper());
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("spark-async-sampler-worker-thread").setUncaughtExceptionHandler(SparkThreadFactory.EXCEPTION_HANDLER).build());
    }

    @Override
    public void start() {
        boolean shouldNotRotate;
        super.start();
        TickHook tickHook = this.platform.getTickHook();
        if (tickHook != null) {
            this.windowStatisticsCollector.startCountingTicks(tickHook);
        }
        int window = ProfilingWindowUtils.windowNow();
        AsyncProfilerJob job = this.profilerAccess.startNewProfilerJob();
        job.init(this.platform, this.sampleCollector, this.threadDumper, window, this.background);
        job.start();
        this.windowStatisticsCollector.recordWindowStartTime(window);
        this.currentJob = job;
        boolean bl = shouldNotRotate = this.sampleCollector instanceof SampleCollector.Allocation && ((SampleCollector.Allocation)this.sampleCollector).isLiveOnly();
        if (!shouldNotRotate) {
            this.scheduler.scheduleAtFixedRate(this::rotateProfilerJob, 60L, 60L, TimeUnit.SECONDS);
        }
        this.recordInitialGcStats();
        this.scheduleTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateProfilerJob() {
        try {
            Object[] objectArray = this.currentJobMutex;
            synchronized (this.currentJobMutex) {
                AsyncProfilerJob previousJob = this.currentJob;
                if (previousJob == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    previousJob.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int window = previousJob.getWindow() + 1;
                AsyncProfilerJob newJob = this.profilerAccess.startNewProfilerJob();
                newJob.init(this.platform, this.sampleCollector, this.threadDumper, window, this.background);
                newJob.start();
                this.windowStatisticsCollector.recordWindowStartTime(window);
                this.currentJob = newJob;
                try {
                    this.windowStatisticsCollector.measureNow(previousJob.getWindow());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                previousJob.aggregate(this.dataAggregator);
                IntPredicate predicate = ProfilingWindowUtils.keepHistoryBefore(window);
                this.dataAggregator.pruneData(predicate);
                this.windowStatisticsCollector.pruneStatistics(predicate);
                this.scheduler.execute(() -> this.processWindowRotate());
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        {
            return;
        }
    }

    private void scheduleTimeout() {
        if (this.autoEndTime == -1L) {
            return;
        }
        long delay = this.autoEndTime - System.currentTimeMillis();
        if (delay <= 0L) {
            return;
        }
        this.scheduler.schedule(() -> {
            this.stop(false);
            this.future.complete(this);
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean cancelled) {
        super.stop(cancelled);
        Object[] objectArray = this.currentJobMutex;
        synchronized (this.currentJobMutex) {
            this.currentJob.stop();
            if (!cancelled) {
                this.windowStatisticsCollector.measureNow(this.currentJob.getWindow());
                this.currentJob.aggregate(this.dataAggregator);
            } else {
                this.currentJob.deleteOutputFile();
            }
            this.currentJob = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.socketStatisticsTask != null) {
                this.socketStatisticsTask.cancel(false);
            }
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            return;
        }
    }

    @Override
    public void attachSocket(ViewerSocket socket) {
        super.attachSocket(socket);
        if (this.socketStatisticsTask == null) {
            this.socketStatisticsTask = this.scheduler.scheduleAtFixedRate(() -> this.sendStatisticsToSocket(), 10L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public SamplerMode getMode() {
        return this.sampleCollector.getMode();
    }

    @Override
    public SparkSamplerProtos.SamplerData toProto(SparkPlatform platform, Sampler.ExportProps exportProps) {
        SparkSamplerProtos.SamplerData.Builder proto = SparkSamplerProtos.SamplerData.newBuilder();
        if (exportProps.channelInfo() != null) {
            proto.setChannelInfo(exportProps.channelInfo());
        }
        this.writeMetadataToProto(proto, platform, exportProps.creator(), exportProps.comment(), this.dataAggregator);
        this.writeDataToProto(proto, this.dataAggregator, exportProps.mergeMode().get(), exportProps.classSourceLookup().get(), platform::createClassFinder);
        return (SparkSamplerProtos.SamplerData)proto.build();
    }
}

