/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge.plugin;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.MetadataProvider;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.neoforge.NeoForgeCommandSender;
import me.lucko.spark.neoforge.NeoForgeExtraMetadataProvider;
import me.lucko.spark.neoforge.NeoForgePlatformInfo;
import me.lucko.spark.neoforge.NeoForgeSparkMod;
import me.lucko.spark.neoforge.NeoForgeTickHook;
import me.lucko.spark.neoforge.NeoForgeTickReporter;
import me.lucko.spark.neoforge.NeoForgeWorldInfoProvider;
import me.lucko.spark.neoforge.plugin.NeoForgeSparkPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;

public class NeoForgeClientSparkPlugin
extends NeoForgeSparkPlugin
implements Command<CommandSourceStack>,
SuggestionProvider<CommandSourceStack> {
    private final Minecraft minecraft;
    private final ThreadDumper gameThreadDumper;

    public static void register(NeoForgeSparkMod mod, FMLClientSetupEvent event) {
        NeoForgeClientSparkPlugin plugin = new NeoForgeClientSparkPlugin(mod, Minecraft.getInstance());
        plugin.enable();
    }

    public NeoForgeClientSparkPlugin(NeoForgeSparkMod mod, Minecraft minecraft) {
        super(mod);
        this.minecraft = minecraft;
        this.gameThreadDumper = new ThreadDumper.Specific(minecraft.gameThread);
    }

    @Override
    public void enable() {
        super.enable();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterClientCommandsEvent e) {
        NeoForgeClientSparkPlugin.registerCommands(e.getDispatcher(), this, this, "sparkc", "sparkclient");
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String[] args = NeoForgeClientSparkPlugin.processArgs(context, false, "sparkc", "sparkclient");
        if (args == null) {
            return 0;
        }
        this.platform.executeCommand(new NeoForgeCommandSender((CommandSource)((CommandSourceStack)context.getSource()).getEntity(), this), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = NeoForgeClientSparkPlugin.processArgs(context, true, "/sparkc", "/sparkclient");
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new NeoForgeCommandSender((CommandSource)((CommandSourceStack)context.getSource()).getEntity(), this), args, builder);
    }

    @Override
    public boolean hasPermission(CommandSource sender, String permission) {
        return true;
    }

    public Stream<NeoForgeCommandSender> getCommandSenders() {
        return Stream.of(new NeoForgeCommandSender((CommandSource)this.minecraft.player, this));
    }

    @Override
    public void executeSync(Runnable task) {
        this.minecraft.executeIfPossible(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    @Override
    public TickHook createTickHook() {
        return new NeoForgeTickHook.Client();
    }

    @Override
    public TickReporter createTickReporter() {
        return new NeoForgeTickReporter.Client();
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new NeoForgeWorldInfoProvider.Client(this.minecraft);
    }

    @Override
    public MetadataProvider createExtraMetadataProvider() {
        return new NeoForgeExtraMetadataProvider(this.minecraft.getResourcePackRepository());
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new NeoForgePlatformInfo(PlatformInfo.Type.CLIENT);
    }

    @Override
    public String getCommandName() {
        return "sparkc";
    }
}

