/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.neoforge.mixin.impl;

import com.google.common.base.Preconditions;
import glitchcore.neoforge.network.GCPayloadFactory;
import glitchcore.network.CustomPacket;
import glitchcore.network.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jodah.typetools.TypeResolver;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PacketHandler.class}, remap=false)
public abstract class MixinPacketHandler {
    @Shadow
    @Final
    private ResourceLocation channelName;
    @Unique
    private Map<Class<?>, CustomPacketPayload.Type<?>> ids = new HashMap();

    @Overwrite
    public <T extends CustomPacket<T>> void register(ResourceLocation name, CustomPacket<T> packet) {
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(ResourceLocation.parse((String)name.toString()));
        this.ids.put(MixinPacketHandler.getPacketDataType(packet), type);
        String modid = name.getNamespace();
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modid).orElseThrow(() -> new IllegalArgumentException("Channel namespace does not belong to a mod"));
        GCPayloadFactory factory = new GCPayloadFactory((CustomPacketPayload.Type<? extends CustomPacketPayload>)type, packet);
        container.getEventBus().addListener(event -> {
            PayloadRegistrar registrar = event.registrar(modid);
            registrar.versioned(modid);
            switch (packet.getPhase()) {
                case PLAY: {
                    registrar.playBidirectional(factory.type(), factory.getCodec(), (IPayloadHandler)factory.getPayloadHandler());
                    break;
                }
                case CONFIGURATION: {
                    registrar.configurationBidirectional(factory.type(), factory.getCodec(), (IPayloadHandler)factory.getPayloadHandler());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Attempted to register packet with unsupported phase " + String.valueOf((Object)packet.getPhase()));
                }
            }
        });
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToPlayer(T data, ServerPlayer player) {
        Objects.requireNonNull(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.createPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToAll(T packet, MinecraftServer server) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)this.createPayload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToHandler(T packet, ServerConfigurationPacketListenerImpl handler) {
        GCPayloadFactory.PacketPayload payload = this.createPayload(packet);
        switch (handler.getConnection().getSending()) {
            case CLIENTBOUND: {
                handler.getConnection().send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)payload));
                break;
            }
            case SERVERBOUND: {
                handler.getConnection().send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)payload));
            }
        }
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToServer(T data) {
        PacketDistributor.sendToServer((CustomPacketPayload)this.createPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Overwrite
    private void init() {
    }

    private GCPayloadFactory.PacketPayload createPayload(CustomPacket<?> packet) {
        Class<?> dataType = MixinPacketHandler.getPacketDataType(packet);
        Preconditions.checkState((boolean)this.ids.containsKey(dataType), (Object)("Unregistered packet data type " + String.valueOf(dataType)));
        return new GCPayloadFactory(this.ids.get(dataType), packet).createPayload();
    }

    private static <T extends CustomPacket<T>> Class<?> getPacketDataType(CustomPacket<T> packet) {
        Class dataType = TypeResolver.resolveRawArgument(CustomPacket.class, packet.getClass());
        if (dataType == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Failed to resolve packet data type: " + String.valueOf(packet));
        }
        return dataType;
    }
}

