/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ars_nouveau")
public class EventQueue {
    @NotNull
    List<ITimedEvent> events = new ArrayList<ITimedEvent>();
    private static EventQueue serverQueue;
    private static EventQueue clientQueue;

    public void tick(@Nullable ServerTickEvent.Post e) {
        if (this.events.isEmpty()) {
            return;
        }
        ArrayList<ITimedEvent> stale = new ArrayList<ITimedEvent>();
        for (int i = 0; i < this.events.size(); ++i) {
            ITimedEvent event = this.events.get(i);
            if (event.isExpired()) {
                stale.add(event);
                continue;
            }
            if (e == null) {
                event.tick(false);
                continue;
            }
            event.tick((ServerTickEvent)e);
        }
        this.events.removeAll(stale);
    }

    public void addEvent(ITimedEvent event) {
        this.events.add(event);
    }

    public static EventQueue getServerInstance() {
        if (serverQueue == null) {
            serverQueue = new EventQueue();
        }
        return serverQueue;
    }

    public static EventQueue getClientQueue() {
        if (clientQueue == null) {
            clientQueue = new EventQueue();
        }
        return clientQueue;
    }

    public void clear() {
        for (ITimedEvent event : this.events) {
            event.onServerStopping();
        }
        this.events = new ArrayList<ITimedEvent>();
    }

    private EventQueue() {
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post e) {
        EventQueue.getServerInstance().tick(e);
    }

    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Post e) {
        EventQueue.getClientQueue().tick(null);
    }
}

