/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.hollingsworth.arsnouveau.api.recipe.CraftingManager;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class PotionCraftingManager
extends CraftingManager {
    private boolean hasObtainedPotion;
    private PotionContents potionNeeded;
    public PotionContents potionOut;

    public PotionCraftingManager() {
    }

    public PotionCraftingManager(PotionContents potionNeeded, List<ItemStack> itemsNeeded, PotionContents potionOut) {
        super(ItemStack.EMPTY, itemsNeeded);
        this.potionNeeded = potionNeeded;
        this.potionOut = potionOut;
        this.neededItems = itemsNeeded;
        this.remainingItems = itemsNeeded;
        this.outputStack = ItemStack.EMPTY;
        this.hasObtainedPotion = potionNeeded == PotionContents.EMPTY || potionNeeded.is(Potions.WATER);
    }

    @Override
    public boolean canBeCompleted() {
        return !this.needsPotion() && super.canBeCompleted();
    }

    public boolean needsPotion() {
        return !this.hasObtainedPotion;
    }

    public PotionContents getPotionNeeded() {
        return this.potionNeeded;
    }

    public void setObtainedPotion(boolean hasObtainedPotion) {
        this.hasObtainedPotion = hasObtainedPotion;
    }

    @Override
    public void completeCraft(WixieCauldronTile tile) {
        Level level = tile.getLevel();
        BlockPos worldPosition = tile.getBlockPos();
        BlockPos jarPos = WixieCauldronTile.findPotionStorage(tile.getLevel(), tile.getBlockPos(), this.potionOut);
        if (jarPos == null) {
            if (!tile.needsPotionStorage()) {
                tile.setNeedsPotionStorage(true);
                level.sendBlockUpdated(worldPosition, level.getBlockState(worldPosition), level.getBlockState(worldPosition), 3);
            }
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(jarPos);
        if (blockEntity instanceof PotionJarTile) {
            PotionJarTile jar = (PotionJarTile)blockEntity;
            tile.setNeedsPotionStorage(false);
            jar.add(this.potionOut, 300);
            ParticleColor color2 = ParticleColor.fromInt(jar.getColor());
            EntityFlyingItem flying = new EntityFlyingItem(level, new Vec3((double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 1.0, (double)worldPosition.getZ() + 0.5), new Vec3((double)jarPos.getX() + 0.5, (double)jarPos.getY(), (double)jarPos.getZ() + 0.5), Math.round(255.0f * color2.getRed()), Math.round(255.0f * color2.getGreen()), Math.round(255.0f * color2.getBlue())).withNoTouch();
            level.addFreshEntity((Entity)flying);
        }
        super.completeCraft(tile);
    }

    @Override
    public boolean isCraftInvalid() {
        return false;
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        tag.put("potionout", ANCodecs.encode(PotionContents.CODEC, this.potionOut));
        tag.put("potionNeeded", ANCodecs.encode(PotionContents.CODEC, this.getPotionNeeded()));
        tag.putBoolean("gotPotion", this.hasObtainedPotion);
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        this.potionOut = (PotionContents)ANCodecs.decode(PotionContents.CODEC, (Tag)tag.getCompound("potionout"));
        this.potionNeeded = (PotionContents)ANCodecs.decode(PotionContents.CODEC, (Tag)tag.getCompound("potionNeeded"));
        this.hasObtainedPotion = tag.getBoolean("gotPotion");
    }
}

