/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.ItemCasterProvider;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpellCasterRegistry {
    private static final ConcurrentHashMap<ResourceLocation, ItemCasterProvider> MAP = new ConcurrentHashMap();

    @Nullable
    public static AbstractCaster<?> from(ItemStack stack) {
        return MAP.getOrDefault(stack.getItem().builtInRegistryHolder().key().location(), s -> (AbstractCaster)s.get(DataComponentRegistry.SPELL_CASTER)).getSpellCaster(stack);
    }

    public static boolean hasCaster(ItemStack stack) {
        return MAP.containsKey(stack.getItem().builtInRegistryHolder().key().location());
    }

    public static void register(ItemLike itemLike, ItemCasterProvider provider) {
        MAP.put(itemLike.asItem().builtInRegistryHolder().key().location(), provider);
    }

    public static void register(ResourceLocation location, ItemCasterProvider provider) {
        MAP.put(location, provider);
    }

    static {
        SpellCasterRegistry.register(ItemsRegistry.NOVICE_SPELLBOOK, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.SPELL_CASTER));
        SpellCasterRegistry.register(ItemsRegistry.APPRENTICE_SPELLBOOK, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.SPELL_CASTER));
        SpellCasterRegistry.register(ItemsRegistry.ARCHMAGE_SPELLBOOK, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.SPELL_CASTER));
        SpellCasterRegistry.register(ItemsRegistry.CREATIVE_SPELLBOOK, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.SPELL_CASTER));
        SpellCasterRegistry.register(ItemsRegistry.SCRY_CASTER, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.SCRY_CASTER));
        SpellCasterRegistry.register(ItemsRegistry.CASTER_TOME, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.TOME_CASTER));
        SpellCasterRegistry.register(ItemsRegistry.SPELL_PARCHMENT, (ItemStack stack) -> (AbstractCaster)stack.get(DataComponentRegistry.SPELL_CASTER));
    }
}

