/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.RitualUtil;
import com.hollingsworth.arsnouveau.api.ritual.StructureComparator;
import com.hollingsworth.arsnouveau.common.mixin.structure.StructureTemplateAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;

public abstract class StructureRitual
extends AbstractRitual {
    public ResourceLocation structure;
    public BlockPos offset;
    public List<StructureTemplate.StructureBlockInfo> blocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
    public List<StructureTemplate.StructureEntityInfo> entityInfoList = new ArrayList<StructureTemplate.StructureEntityInfo>();
    public int index;
    public int sourceRequired;
    public boolean hasConsumed;
    public ResourceKey<Biome> biome;

    public StructureRitual(ResourceLocation structure, BlockPos offset, int sourceRequired, ResourceKey<Biome> biome) {
        this.structure = structure;
        this.offset = offset;
        this.sourceRequired = sourceRequired;
        this.hasConsumed = sourceRequired == 0;
        this.biome = biome;
    }

    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        if (this.getWorld().isClientSide) {
            return;
        }
        this.setup();
    }

    public void setup() {
        if (this.getWorld().isClientSide) {
            return;
        }
        StructureTemplateManager manager = this.getWorld().getServer().getStructureManager();
        StructureTemplate structureTemplate = manager.getOrCreate(this.structure);
        List infoList = ((StructureTemplate.Palette)structureTemplate.palettes.get(0)).blocks();
        this.blocks = new ArrayList<StructureTemplate.StructureBlockInfo>(infoList.stream().filter(b -> !b.state().isAir()).toList());
        this.blocks.sort(new StructureComparator(this.getPos(), this.offset));
        this.entityInfoList = new ArrayList<StructureTemplate.StructureEntityInfo>(((StructureTemplateAccessor)structureTemplate).getEntityInfoList());
    }

    @Override
    protected void tick() {
        if (this.getWorld().isClientSide) {
            return;
        }
        if (!this.hasConsumed) {
            this.setNeedsSource(true);
            return;
        }
        int placeCount = 0;
        while (placeCount < 5) {
            if (this.index >= this.blocks.size()) {
                for (StructureTemplate.StructureEntityInfo entityInfo : this.entityInfoList) {
                    Optional entity;
                    BlockPos translatedPos = this.getPos().offset(entityInfo.blockPos.getX(), entityInfo.blockPos.getY(), entityInfo.blockPos.getZ()).offset((Vec3i)this.offset);
                    try {
                        CompoundTag entityTag = entityInfo.nbt;
                        entityTag.remove("UUID");
                        entity = EntityType.create((CompoundTag)entityTag, (Level)this.getWorld());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!entity.isPresent()) continue;
                    ((Entity)entity.get()).moveTo((double)translatedPos.getX(), (double)translatedPos.getY(), (double)translatedPos.getZ());
                    this.getWorld().addFreshEntity((Entity)entity.get());
                }
                this.setFinished();
                return;
            }
            StructureTemplate.StructureBlockInfo blockInfo = this.blocks.get(this.index);
            BlockPos translatedPos = this.getPos().offset(blockInfo.pos().getX(), blockInfo.pos().getY(), blockInfo.pos().getZ()).offset((Vec3i)this.offset);
            if (this.getWorld().getBlockState(translatedPos).canBeReplaced()) {
                this.getWorld().setBlock(translatedPos, blockInfo.state(), 2);
                BlockEntity blockentity1 = this.getWorld().getBlockEntity(translatedPos);
                if (blockentity1 != null) {
                    if (blockentity1 instanceof RandomizableContainerBlockEntity) {
                        blockInfo.nbt().putLong("LootTableSeed", this.getWorld().random.nextLong());
                    }
                    if (blockInfo.nbt() != null) {
                        blockentity1.loadWithComponents(blockInfo.nbt(), (HolderLookup.Provider)this.getWorld().registryAccess());
                    }
                }
                this.getWorld().playSound(null, translatedPos, blockInfo.state().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ++placeCount;
                if (this.biome != null) {
                    RitualUtil.changeBiome(this.getWorld(), translatedPos, this.biome);
                }
            }
            ++this.index;
        }
    }

    @Override
    public void setNeedsSource(boolean needMana) {
        super.setNeedsSource(needMana);
        if (!needMana) {
            this.hasConsumed = true;
        }
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        this.index = tag.getInt("index");
        this.hasConsumed = tag.getBoolean("hasConsumed");
        this.setup();
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        tag.putInt("index", this.index);
        tag.putBoolean("hasConsumed", this.hasConsumed);
    }

    @Override
    public int getSourceCost() {
        return this.sourceRequired;
    }

    @Override
    public abstract ResourceLocation getRegistryName();
}

