/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.sound;

import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ConfiguredSpellSound
implements Cloneable {
    public static final MapCodec<ConfiguredSpellSound> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpellSound.CODEC.codec().optionalFieldOf("sound", (Object)SoundRegistry.DEFAULT_SPELL_SOUND).forGetter(s -> s.sound), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(s -> Float.valueOf(s.volume)), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(s -> Float.valueOf(s.pitch))).apply((Applicative)instance, ConfiguredSpellSound::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConfiguredSpellSound> STREAM = StreamCodec.of((buf, val) -> {
        SpellSound.STREAM.encode(buf, (Object)val.getSound());
        buf.writeFloat(val.getVolume());
        buf.writeFloat(val.getPitch());
    }, buf -> {
        SpellSound sound = (SpellSound)SpellSound.STREAM.decode(buf);
        float volume = buf.readFloat();
        float pitch = buf.readFloat();
        return new ConfiguredSpellSound(sound, volume, pitch);
    });
    public static ConfiguredSpellSound EMPTY = new ConfiguredSpellSound(SoundRegistry.EMPTY_SPELL_SOUND, 1.0f, 1.0f);
    public static ConfiguredSpellSound DEFAULT = new ConfiguredSpellSound(SoundRegistry.DEFAULT_SPELL_SOUND, 1.0f, 1.0f);
    private final SpellSound sound;
    private final float volume;
    private final float pitch;

    public ConfiguredSpellSound(SpellSound sound) {
        this(sound, 1.0f, 1.0f);
    }

    public ConfiguredSpellSound(@Nullable SpellSound spellSound, float aFloat, float aFloat1) {
        this.sound = spellSound;
        this.volume = aFloat;
        this.pitch = aFloat1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredSpellSound that = (ConfiguredSpellSound)o;
        return Float.compare(that.volume, this.volume) == 0 && Float.compare(that.pitch, this.pitch) == 0 && Objects.equals(this.sound, that.sound);
    }

    public int hashCode() {
        return Objects.hash(this.sound, Float.valueOf(this.volume), Float.valueOf(this.pitch));
    }

    public String toString() {
        return "ConfiguredSpellSound{sound=" + String.valueOf(this.sound) + ", volume=" + this.volume + ", pitch=" + this.pitch + "}";
    }

    public ConfiguredSpellSound clone() {
        try {
            ConfiguredSpellSound clone = (ConfiguredSpellSound)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public SpellSound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

