/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSlotMap;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function6;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCaster<T extends AbstractCaster<T>>
implements TooltipProvider {
    protected final SpellSlotMap spells;
    protected final int slot;
    protected final String flavorText;
    protected final boolean isHidden;
    protected final String hiddenText;
    protected final int maxSlots;

    public static <T extends AbstractCaster<T>> MapCodec<T> createCodec(Function6<Integer, String, Boolean, String, Integer, SpellSlotMap, T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("current_slot", (Object)0).forGetter(s -> s.slot), (App)Codec.STRING.optionalFieldOf("flavor_text", (Object)"").forGetter(s -> s.flavorText), (App)Codec.BOOL.optionalFieldOf("is_hidden", (Object)false).forGetter(s -> s.isHidden), (App)Codec.STRING.optionalFieldOf("hidden_text", (Object)"").forGetter(s -> s.hiddenText), (App)Codec.INT.optionalFieldOf("max_slots", (Object)1).forGetter(s -> s.maxSlots), (App)SpellSlotMap.CODEC.optionalFieldOf("spells", (Object)new SpellSlotMap((Map<Integer, Spell>)ImmutableMap.of())).forGetter(s -> s.spells)).apply((Applicative)instance, constructor));
    }

    public static <T extends AbstractCaster<T>> StreamCodec<RegistryFriendlyByteBuf, T> createStream(Function6<Integer, String, Boolean, String, Integer, SpellSlotMap, T> constructor) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, s -> s.slot, (StreamCodec)ByteBufCodecs.STRING_UTF8, s -> s.flavorText, (StreamCodec)ByteBufCodecs.BOOL, s -> s.isHidden, (StreamCodec)ByteBufCodecs.STRING_UTF8, s -> s.hiddenText, (StreamCodec)ByteBufCodecs.INT, s -> s.maxSlots, SpellSlotMap.STREAM, s -> s.spells, constructor);
    }

    public abstract MapCodec<T> codec();

    public abstract StreamCodec<RegistryFriendlyByteBuf, T> streamCodec();

    public AbstractCaster(int slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        this.slot = slot;
        this.flavorText = flavorText == null ? "" : flavorText;
        this.isHidden = isHidden;
        this.hiddenText = hiddenText == null ? "" : hiddenText;
        this.maxSlots = maxSlots;
        this.spells = spells;
    }

    public AbstractCaster() {
        this(0, "", false, "", 1);
    }

    public AbstractCaster(int maxSlots) {
        this(0, "", false, "", maxSlots);
    }

    public AbstractCaster(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots) {
        this(slot, flavorText, isHidden, hiddenText, maxSlots, new SpellSlotMap((Map<Integer, Spell>)ImmutableMap.of()));
    }

    public T setCurrentSlot(int slot) {
        return this.build(slot, this.flavorText, this.isHidden, this.hiddenText, this.maxSlots, this.spells);
    }

    public T setSpell(Spell spell, int slot) {
        return this.build(this.slot, this.flavorText, this.isHidden, this.hiddenText, this.maxSlots, this.spells.put(slot, spell));
    }

    public T setFlavorText(String str) {
        return this.build(this.slot, str, this.isHidden, this.hiddenText, this.maxSlots, this.spells);
    }

    public T setSpellName(String name, int slot) {
        Spell spell = this.getSpell(slot);
        return this.build(this.slot, this.flavorText, this.isHidden, this.hiddenText, this.maxSlots, this.spells.put(slot, new Spell(name, spell.color(), spell.sound(), new ArrayList<AbstractSpellPart>(spell.unsafeList()))));
    }

    public T setHidden(boolean hidden) {
        return this.build(this.slot, this.flavorText, hidden, this.hiddenText, this.maxSlots, this.spells);
    }

    public T setHiddenRecipe(String recipe) {
        return this.build(this.slot, this.flavorText, this.isHidden, recipe, this.maxSlots, this.spells);
    }

    public T setMaxSlots(int slots) {
        return this.build(this.slot, this.flavorText, this.isHidden, this.hiddenText, slots, this.spells);
    }

    public T setSound(ConfiguredSpellSound sound, int slot) {
        Spell spell = this.getSpell(slot);
        return this.build(this.slot, this.flavorText, this.isHidden, this.hiddenText, this.maxSlots, this.spells.put(slot, new Spell(spell.name(), spell.color(), sound, new ArrayList<AbstractSpellPart>(spell.unsafeList()))));
    }

    public T setColor(ParticleColor color, int slot) {
        Spell spell = this.getSpell(slot);
        return this.build(this.slot, this.flavorText, this.isHidden, this.hiddenText, this.maxSlots, this.spells.put(slot, new Spell(spell.name(), color, spell.sound(), new ArrayList<AbstractSpellPart>(spell.unsafeList()))));
    }

    @NotNull
    public Spell getSpell() {
        return this.spells.getOrDefault(this.getCurrentSlot(), new Spell());
    }

    @NotNull
    public Spell getSpell(int slot) {
        return this.spells.getOrDefault(slot, new Spell());
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    public int getCurrentSlot() {
        return this.slot;
    }

    public ParticleColor getColor(int slot) {
        return this.getSpell(slot).color();
    }

    public String getSpellName(int slot) {
        return this.getSpell(slot).name();
    }

    public boolean isSpellHidden() {
        return this.isHidden;
    }

    public String getHiddenRecipe() {
        return this.hiddenText;
    }

    public String getFlavorText() {
        return this.flavorText == null ? "" : this.flavorText;
    }

    @NotNull
    public ConfiguredSpellSound getSound(int slot) {
        return this.getSpell(slot).sound();
    }

    public SpellSlotMap getSpells() {
        return this.spells;
    }

    public T setNextSlot() {
        int slot = this.getCurrentSlot() + 1;
        if (slot >= this.getMaxSlots()) {
            slot = 0;
        }
        return this.setCurrentSlot(slot);
    }

    public T setPreviousSlot() {
        int slot = this.getCurrentSlot() - 1;
        if (slot < 0) {
            slot = this.getMaxSlots() - 1;
        }
        return this.setCurrentSlot(slot);
    }

    public T setSpell(Spell spell) {
        return this.setSpell(spell, this.getCurrentSlot());
    }

    @NotNull
    public ParticleColor getColor() {
        return this.getColor(this.getCurrentSlot());
    }

    public T setColor(ParticleColor color) {
        return this.setColor(color, this.getCurrentSlot());
    }

    public T setSound(ConfiguredSpellSound sound) {
        return this.setSound(sound, this.getCurrentSlot());
    }

    public ConfiguredSpellSound getCurrentSound() {
        return this.getSound(this.getCurrentSlot());
    }

    public String getSpellName() {
        return this.getSpellName(this.getCurrentSlot());
    }

    public T setSpellName(String name) {
        return this.setSpellName(name, this.getCurrentSlot());
    }

    @NotNull
    public Spell getSpell(Level world, LivingEntity playerEntity, InteractionHand hand, AbstractCaster caster) {
        return caster.getSpell();
    }

    public Spell modifySpellBeforeCasting(Level worldIn, @Nullable Entity playerIn, @Nullable InteractionHand handIn, Spell spell) {
        return spell;
    }

    public InteractionResultHolder<ItemStack> castSpell(Level worldIn, LivingEntity entity, InteractionHand handIn, @Nullable Component invalidMessage, @NotNull Spell spell) {
        EntityHitResult entityHitResult;
        LivingCaster livingCaster;
        ANFakePlayer player;
        ItemStack stack = entity.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            return InteractionResultHolder.pass((Object)entity.getItemInHand(handIn));
        }
        if (!(spell = this.modifySpellBeforeCasting(worldIn, (Entity)entity, handIn, spell)).isValid() && invalidMessage != null) {
            PortUtil.sendMessageNoSpam((Entity)entity, invalidMessage);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (entity instanceof Player) {
            Player thisPlayer = (Player)entity;
            v0 = thisPlayer;
        } else {
            v0 = player = ANFakePlayer.getPlayer((ServerLevel)worldIn);
        }
        if (entity instanceof Player) {
            Player pCaster = (Player)entity;
            livingCaster = new PlayerCaster(pCaster);
        } else {
            livingCaster = new LivingCaster(entity);
        }
        LivingCaster wrappedCaster = livingCaster;
        SpellResolver resolver = this.getSpellResolver(new SpellContext(worldIn, spell, entity, wrappedCaster, stack), worldIn, (LivingEntity)player, handIn);
        boolean isSensitive = resolver.spell.getBuffsAtIndex(0, entity, AugmentSensitive.INSTANCE) > 0;
        HitResult result = SpellUtil.rayTrace((Entity)entity, 0.5 + player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue(), 0.0f, isSensitive);
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            BlockEntity tile = worldIn.getBlockEntity(blockHit.getBlockPos());
            if (tile instanceof ScribesTile) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            if (!entity.isShiftKeyDown() && tile != null && !worldIn.getBlockState(blockHit.getBlockPos()).is(BlockTagProvider.IGNORE_TILE)) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        if (result instanceof EntityHitResult && (entityHitResult = (EntityHitResult)result).getEntity() instanceof LivingEntity) {
            if (resolver.onCastOnEntity(stack, entityHitResult.getEntity(), handIn)) {
                this.playSound(entity.getOnPos(), worldIn, (Entity)entity, this.getCurrentSound(), SoundSource.PLAYERS);
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (result.getType() == HitResult.Type.BLOCK || isSensitive) {
                if (entity instanceof Player) {
                    UseOnContext context = new UseOnContext((Player)player, handIn, (BlockHitResult)result);
                    if (resolver.onCastOnBlock(context)) {
                        this.playSound(entity.getOnPos(), worldIn, (Entity)entity, this.getCurrentSound(), SoundSource.PLAYERS);
                    }
                } else if (resolver.onCastOnBlock(blockHitResult)) {
                    this.playSound(entity.getOnPos(), worldIn, (Entity)entity, this.getCurrentSound(), SoundSource.NEUTRAL);
                }
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
        }
        if (resolver.onCast(stack, worldIn)) {
            this.playSound(entity.getOnPos(), worldIn, (Entity)entity, this.getCurrentSound(), SoundSource.PLAYERS);
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    public InteractionResultHolder<ItemStack> castSpell(Level worldIn, LivingEntity playerIn, InteractionHand handIn, Component invalidMessage) {
        return this.castSpell(worldIn, playerIn, handIn, invalidMessage, this.getSpell(worldIn, playerIn, handIn, this));
    }

    public T copyFromCaster(AbstractCaster<?> other) {
        AbstractCaster<T> self = this;
        for (int i = 0; i < this.getMaxSlots() && i < other.getMaxSlots(); ++i) {
            self = self.setSpell(other.getSpell(i), i);
            self = self.setFlavorText(other.getFlavorText());
        }
        return (T)self;
    }

    public void saveToStack(ItemStack stack) {
        stack.set(this.getComponentType(), (Object)this);
    }

    public abstract DataComponentType getComponentType();

    public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
        return new SpellResolver(context);
    }

    public void playSound(BlockPos pos, Level worldIn, @Nullable Entity playerIn, ConfiguredSpellSound configuredSound, SoundSource source) {
        if (configuredSound == null || configuredSound.getSound() == null || configuredSound.getSound().getSoundEvent() == null || configuredSound.equals(ConfiguredSpellSound.EMPTY)) {
            return;
        }
        worldIn.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, configuredSound.getSound().getSoundEvent(), source, configuredSound.getVolume(), configuredSound.getPitch());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCaster caster = (AbstractCaster)o;
        return this.slot == caster.slot && this.isHidden == caster.isHidden && this.maxSlots == caster.maxSlots && Objects.equals(this.spells, caster.spells) && Objects.equals(this.flavorText, caster.flavorText) && Objects.equals(this.hiddenText, caster.hiddenText);
    }

    public int hashCode() {
        return Objects.hash(this.spells, this.slot, this.flavorText, this.isHidden, this.hiddenText, this.maxSlots);
    }

    protected abstract T build(int var1, String var2, Boolean var3, String var4, int var5, SpellSlotMap var6);

    public void addToTooltip(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext pContext, @NotNull Consumer<Component> pTooltipAdder, @NotNull TooltipFlag pTooltipFlag) {
        if (this.getSpell().isEmpty()) {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.tooltip.can_inscribe"));
            return;
        }
        if (!this.getSpellName().isEmpty()) {
            pTooltipAdder.accept((Component)Component.literal((String)this.getSpellName()));
        }
        if (this.isSpellHidden()) {
            pTooltipAdder.accept((Component)Component.literal((String)this.getHiddenRecipe()).withStyle(Style.EMPTY.withFont(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"alt")).withColor(ChatFormatting.GOLD)));
        } else {
            Spell spell = this.getSpell();
            pTooltipAdder.accept((Component)Component.literal((String)spell.getDisplayString()));
        }
        if (!this.getFlavorText().isEmpty()) {
            pTooltipAdder.accept((Component)Component.literal((String)this.getFlavorText()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE)));
        }
    }
}

