/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootUtil {
    public static ItemStack getDefaultFakeTool() {
        return new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
    }

    public static ItemStack getDefaultFakeWeapon() {
        return new ItemStack((ItemLike)Items.DIAMOND_SWORD);
    }

    public static LootParams.Builder getDefaultContext(ServerLevel serverWorld, BlockPos pos, LivingEntity shooter) {
        return new LootParams.Builder(serverWorld).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.THIS_ENTITY, (Object)shooter).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)serverWorld.getBlockEntity(pos));
    }

    public static LootParams.Builder getSilkContext(ServerLevel serverWorld, BlockPos pos, LivingEntity shooter) {
        ItemStack stack = LootUtil.getDefaultFakeTool();
        stack.enchant(HolderHelper.unwrap((Level)serverWorld, Enchantments.SILK_TOUCH), 1);
        return LootUtil.getDefaultContext(serverWorld, pos, shooter).withParameter(LootContextParams.TOOL, (Object)stack);
    }

    public static LootParams.Builder getFortuneContext(ServerLevel world, BlockPos pos, LivingEntity shooter, int enchLevel) {
        ItemStack stack = LootUtil.getDefaultFakeTool();
        stack.enchant(HolderHelper.unwrap((Level)world, Enchantments.FORTUNE), enchLevel);
        return LootUtil.getDefaultContext(world, pos, shooter).withParameter(LootContextParams.TOOL, (Object)stack);
    }

    public static LootParams.Builder getLootingContext(ServerLevel world, LivingEntity player, LivingEntity slainEntity, int looting, DamageSource source) {
        ItemStack stack = LootUtil.getDefaultFakeWeapon();
        stack.enchant(HolderHelper.unwrap((Level)world, Enchantments.LOOTING), looting);
        return new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, (Object)slainEntity).withParameter(LootContextParams.ORIGIN, (Object)new Vec3(slainEntity.getX(), slainEntity.getY(), slainEntity.getZ())).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)ANFakePlayer.getPlayer(world)).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity()).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withLuck(player instanceof Player ? ((Player)player).getLuck() : 1.0f).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.EXPLOSION_RADIUS, (Object)Float.valueOf(0.0f)).withParameter(LootContextParams.BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState()).withOptionalParameter(LootContextParams.BLOCK_ENTITY, null);
    }
}

