/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import com.hollingsworth.arsnouveau.client.container.SlotStorage;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.ServerToClientStoragePacket;
import com.hollingsworth.arsnouveau.common.network.SetTerminalSettingsPacket;
import com.hollingsworth.arsnouveau.common.network.UpdateStorageItemsPacket;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class StorageTerminalMenu
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    protected StorageLecternTile te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = new ArrayList<StoredItemStack>();
    protected Inventory pinv;
    public String search;
    public String selectedTab = null;
    public Map<StoredItemStack, StoredItemStack> itemMap = new HashMap<StoredItemStack, StoredItemStack>();
    private Object2LongMap<StoredItemStack> itemLongMap = new Object2LongOpenHashMap();

    public StorageTerminalMenu(int id, Inventory inv, StorageLecternTile te) {
        this((MenuType)MenuRegistry.STORAGE.get(), id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv, StorageLecternTile te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots(false);
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv) {
        this(type, id, inv, null);
    }

    protected void addPlayerSlots(Inventory playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.slots.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public void addStorageSlots(boolean expanded) {
        this.storageSlotList.clear();
        int lines = !expanded ? 3 : 7;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.storageSlotList.add(new SlotStorage(this.te, i * 9 + j, 13 + j * 18, 21 + i * 18));
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.te != null && this.te.canInteractWith(playerIn);
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void broadcastChanges() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks(this.selectedTab);
        ArrayList<StoredItemStack> toWrite = new ArrayList<StoredItemStack>();
        HashSet found = new HashSet();
        itemsCount.forEach((s, c) -> {
            long pc = this.itemLongMap.getLong(s);
            if (pc != 0L) {
                found.add(s);
            }
            if (pc != c) {
                toWrite.add(new StoredItemStack(s.getStack(), (long)c));
            }
        });
        this.itemLongMap.forEach((s, c) -> {
            if (!found.contains(s)) {
                toWrite.add(new StoredItemStack(s.getStack(), 0L));
            }
        });
        this.itemLongMap.clear();
        this.itemLongMap.putAll(itemsCount);
        Networking.sendToPlayerClient(new UpdateStorageItemsPacket(toWrite), (ServerPlayer)this.pinv.player);
        CompoundTag tag = new CompoundTag();
        if (!this.te.getLastSearch().equals(this.search)) {
            this.search = this.te.getLastSearch();
            tag.putString("search", this.search);
        }
        ListTag tabs = new ListTag();
        for (String s2 : this.te.getTabNames()) {
            CompoundTag nameTag = new CompoundTag();
            nameTag.putString("name", s2);
            tabs.add((Object)nameTag);
        }
        tag.put("tabs", (Tag)tabs);
        Networking.sendToPlayerClient(new SetTerminalSettingsPacket(this.te.sortSettings, null), (ServerPlayer)this.pinv.player);
        Networking.sendToPlayerClient(new ServerToClientStoragePacket(tag), (ServerPlayer)this.pinv.player);
        super.broadcastChanges();
    }

    public final ItemStack quickMoveStack(Player playerIn, int index) {
        if (this.slots.size() <= index) {
            return ItemStack.EMPTY;
        }
        if (index > this.playerSlotsStart && this.te != null) {
            if (this.slots.get(index) != null && ((Slot)this.slots.get(index)).hasItem()) {
                Slot slot = (Slot)this.slots.get(index);
                ItemStack slotStack = slot.getItem();
                StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.getCount()), this.selectedTab);
                ItemStack itemstack = c != null ? c.getActualStack() : ItemStack.EMPTY;
                slot.set(itemstack);
                if (!playerIn.level.isClientSide) {
                    this.broadcastChanges();
                }
            }
        } else {
            return this.shiftClickItems(playerIn, index);
        }
        return ItemStack.EMPTY;
    }

    protected ItemStack shiftClickItems(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelperIn) {
    }

    public void clearCraftingContent() {
    }

    public boolean recipeMatches(RecipeHolder pRecipe) {
        return false;
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return 0;
    }

    public int getGridHeight() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public void updateItems(List<StoredItemStack> stacks) {
        stacks.forEach(s -> {
            if (s.getQuantity() == 0L) {
                this.itemMap.remove(s);
            } else {
                this.itemMap.put((StoredItemStack)s, (StoredItemStack)s);
            }
        });
        this.itemList = new ArrayList<StoredItemStack>(this.itemMap.values());
        this.pinv.setChanged();
    }

    public final void receiveClientNBTPacket(CompoundTag message) {
        if (message.contains("search")) {
            this.search = message.getString("search");
        }
    }

    public void receive(HolderLookup.Provider reg, CompoundTag message) {
        if (this.pinv.player.isSpectator()) {
            return;
        }
        if (message.contains("search")) {
            this.te.setLastSearch(message.getString("search"));
        }
        this.receiveInteract(message);
    }

    public void receiveSettings(SortSettings settings, String selectedTab) {
        this.selectedTab = selectedTab;
        this.te.setSorting(settings);
    }

    public void receiveInteract(CompoundTag tag) {
        if (!tag.contains("interaction")) {
            return;
        }
        CompoundTag interactTag = tag.getCompound("interaction");
        boolean pullOne = interactTag.getBoolean("pullOne");
        StoredItemStack stack = null;
        if (interactTag.contains("stack")) {
            stack = ANCodecs.decode(StoredItemStack.CODEC, interactTag.get("stack"));
        }
        SlotAction action = SlotAction.values()[interactTag.getInt("action")];
        this.onInteract(stack, action, pullOne);
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int p_150635_) {
        return false;
    }

    public void onInteract(StoredItemStack clicked, SlotAction act, boolean pullOne) {
        ServerPlayer player = (ServerPlayer)this.pinv.player;
        player.resetLastActionTime();
        if (act == SlotAction.SPACE_CLICK) {
            for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                this.quickMoveStack((Player)player, i);
            }
        } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
            ItemStack stack = this.getCarried();
            if (!stack.isEmpty()) {
                StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack), this.selectedTab);
                ItemStack itemstack = rem == null ? ItemStack.EMPTY : rem.getActualStack();
                this.setCarried(itemstack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize(), this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.PULL_ONE) {
            ItemStack stack = this.getCarried();
            if (clicked == null) {
                return;
            }
            if (pullOne) {
                StoredItemStack pulled = this.te.pullStack(clicked, 1, this.selectedTab);
                if (pulled != null) {
                    ItemStack itemstack = pulled.getActualStack();
                    this.moveItemStackTo(itemstack, this.playerSlotsStart + 1, this.slots.size(), true);
                    if (itemstack.getCount() > 0) {
                        this.te.pushOrDrop(itemstack, this.selectedTab);
                    }
                    player.getInventory().setChanged();
                }
            } else if (!stack.isEmpty()) {
                StoredItemStack pulled;
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)clicked.getStack()) && stack.getCount() + 1 <= stack.getMaxStackSize() && (pulled = this.te.pullStack(clicked, 1, this.selectedTab)) != null) {
                    stack.grow(1);
                }
            } else {
                StoredItemStack pulled = this.te.pullStack(clicked, 1, this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_HALF) {
            ItemStack stack = this.getCarried();
            if (!stack.isEmpty()) {
                ItemStack stack1 = stack.split(Math.max(Math.min(stack.getCount(), stack.getMaxStackSize()) / 2, 1));
                ItemStack itemstack = this.te.pushStack(stack1, this.selectedTab);
                stack.grow(!itemstack.isEmpty() ? itemstack.getCount() : 0);
                this.setCarried(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, (int)Math.max(Math.min(clicked.getQuantity() / 2L, (long)(clicked.getMaxStackSize() / 2)), 1L), this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_QUARTER) {
            ItemStack stack = this.getCarried();
            if (!stack.isEmpty()) {
                ItemStack stack1 = stack.split(Math.max(Math.min(stack.getCount(), stack.getMaxStackSize()) / 4, 1));
                ItemStack itemstack = this.te.pushStack(stack1, this.selectedTab);
                stack.grow(!itemstack.isEmpty() ? itemstack.getCount() : 0);
                this.setCarried(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                long maxCount = 64L;
                for (StoredItemStack e : this.itemList) {
                    if (!e.equals(clicked)) continue;
                    maxCount = e.getQuantity();
                }
                StoredItemStack pulled = this.te.pullStack(clicked, (int)Math.max(Math.min(maxCount, (long)clicked.getMaxStackSize()) / 4L, 1L), this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else {
            if (clicked == null) {
                return;
            }
            StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize(), this.selectedTab);
            if (pulled != null) {
                ItemStack itemstack = pulled.getActualStack();
                this.moveItemStackTo(itemstack, this.playerSlotsStart + 1, this.slots.size(), true);
                if (itemstack.getCount() > 0) {
                    this.te.pushOrDrop(itemstack, this.selectedTab);
                }
                player.getInventory().setChanged();
            }
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

    }
}

