/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import com.hollingsworth.arsnouveau.client.gui.BookSlider;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.SoundButton;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetSound;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellSoundAll;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;

public class SoundScreen
extends BaseBook {
    public int casterSlot;
    public InteractionHand stackHand;
    public BookSlider volumeSlider;
    public BookSlider pitchSlider;
    public double volume;
    public double pitch;
    public SpellSound selectedSound;
    public SoundButton selectedButton;

    public SoundScreen(ConfiguredSpellSound configuredSpellSound, int slot, InteractionHand stackHand) {
        this.volume = configuredSpellSound.getVolume() * 100.0f;
        this.pitch = configuredSpellSound.getPitch() * 100.0f;
        this.selectedSound = configuredSpellSound.getSound();
        this.casterSlot = slot;
        this.stackHand = stackHand;
    }

    @Override
    public void init() {
        super.init();
        this.volumeSlider = this.buildSlider(this.bookLeft + 28, this.bookTop + 49, (Component)Component.translatable((String)"ars_nouveau.sounds.volume"), (Component)Component.empty(), this.volume);
        this.pitchSlider = this.buildSlider(this.bookLeft + 28, this.bookTop + 89, (Component)Component.translatable((String)"ars_nouveau.sounds.pitch"), (Component)Component.empty(), this.pitch);
        this.addRenderableWidget((GuiEventListener)this.volumeSlider);
        this.addRenderableWidget((GuiEventListener)this.pitchSlider);
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft + 25, this.bookBottom - 36, 0, 0, 37, 12, 37, 12, "textures/gui/save_icon.png", this::onSaveClick));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft + 165, this.bookBottom - 36, 0, 0, 37, 12, 37, 12, "textures/gui/save_icon.png", this::onSaveAllClick));
        GuiImageButton testButton = new GuiImageButton(this.bookLeft + 90, this.bookBottom - 36, 0, 0, 37, 12, 37, 12, "textures/gui/sound_test_icon.png", this::onTestClick);
        testButton.soundDisabled = true;
        this.addRenderableWidget((GuiEventListener)testButton);
        this.selectedButton = new SoundButton(this.bookLeft + 69, this.bookTop + 131, this.selectedSound, b -> {
            ((SoundButton)b).sound = SoundRegistry.EMPTY_SPELL_SOUND;
            this.selectedSound = SoundRegistry.EMPTY_SPELL_SOUND;
        });
        this.addRenderableWidget((GuiEventListener)this.selectedButton);
        this.addPresets();
    }

    public void addPresets() {
        int PER_ROW = 6;
        int MAX_ROWS = 6;
        boolean nextPage = false;
        int xStart = this.bookLeft + 154;
        int adjustedRowsPlaced = 0;
        int yStart = this.bookTop + 22;
        int adjustedXPlaced = 0;
        List<SpellSound> sounds = SpellSoundRegistry.getSpellSounds();
        for (int i = 0; i < sounds.size(); ++i) {
            SpellSound part = sounds.get(i);
            if (adjustedXPlaced >= 6) {
                ++adjustedRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (adjustedRowsPlaced > 6) {
                if (nextPage) break;
                nextPage = true;
                adjustedRowsPlaced = 0;
            }
            int xOffset = 20 * (adjustedXPlaced % 6) + (nextPage ? 134 : 0);
            int yPlace = adjustedRowsPlaced * 18 + yStart;
            SoundButton cell = new SoundButton(xStart + xOffset, yPlace, part, this::onSoundClick);
            this.addRenderableWidget((GuiEventListener)cell);
            ++adjustedXPlaced;
        }
    }

    public void onSoundClick(Button button) {
        if (button instanceof SoundButton) {
            SoundButton soundButton = (SoundButton)button;
            this.selectedButton.sound = this.selectedSound = soundButton.sound;
        }
    }

    public void onTestClick(Button button) {
        if (this.selectedSound == null) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        BlockPos pos = localPlayer.getOnPos().above(2);
        localPlayer.level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)this.selectedSound.getSoundEvent().value(), SoundSource.PLAYERS, (float)this.volumeSlider.getValue() / 100.0f, (float)this.pitchSlider.getValue() / 100.0f, false);
    }

    public void onSaveClick(Button button) {
        Networking.sendToServer(new PacketSetSound(this.casterSlot, this.selectedSound == null ? ConfiguredSpellSound.EMPTY : new ConfiguredSpellSound(this.selectedSound, (float)this.volumeSlider.getValue() / 100.0f, (float)this.pitchSlider.getValue() / 100.0f), this.stackHand == InteractionHand.MAIN_HAND));
    }

    public void onSaveAllClick(Button button) {
        Networking.sendToServer(new PacketUpdateSpellSoundAll(this.casterSlot, this.selectedSound == null ? ConfiguredSpellSound.EMPTY : new ConfiguredSpellSound(this.selectedSound, (float)this.volumeSlider.getValue() / 100.0f, (float)this.pitchSlider.getValue() / 100.0f), this.stackHand == InteractionHand.MAIN_HAND));
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ArsNouveau.prefix("textures/gui/sound_slider_gilding.png"), 22, 47, 0.0f, 0.0f, 112, 104, 112, 104);
        int color = -8355712;
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.sounds.title").getString(), 51, 24, color, false);
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.color_gui.save").getString(), 37, 160, color, false);
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.color_gui.save_all").getString(), 177, 160, color, false);
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.sounds.test").getString(), 102, 160, color, false);
    }
}

