/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.setup.config.Config;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class ParticleRenderTypes {
    static final ParticleRenderType EMBER_RENDER = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator buffer, TextureManager textureManager) {
            Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
            if (((Boolean)Config.DISABLE_TRANSLUCENT_PARTICLES.get()).booleanValue()) {
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::getParticleShader);
            } else {
                RenderSystem.enableBlend();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE.value);
            }
            RenderSystem.enableCull();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableDepthTest();
            return buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "ars_nouveau:em_rend";
        }
    };
    static final ParticleRenderType EMBER_RENDER_NO_MASK = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator buffer, TextureManager textureManager) {
            if (((Boolean)Config.DISABLE_TRANSLUCENT_PARTICLES.get()).booleanValue()) {
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::getParticleShader);
            } else {
                RenderSystem.enableBlend();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE.value);
            }
            RenderSystem.enableCull();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.disableDepthTest();
            return buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "ars_nouveau:em_rend_no_mask";
        }
    };
}

