/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.registry;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.container.CraftingTerminalScreen;
import com.hollingsworth.arsnouveau.client.events.ClientEvents;
import com.hollingsworth.arsnouveau.client.gui.GuiEntityInfoHUD;
import com.hollingsworth.arsnouveau.client.gui.GuiManaHUD;
import com.hollingsworth.arsnouveau.client.gui.GuiSpellHUD;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.renderer.entity.AmethystGolemModel;
import com.hollingsworth.arsnouveau.client.renderer.entity.AmethystGolemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.AnimBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.BookwyrmRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.ChimeraProjectileRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.CinderRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.DrygmyModel;
import com.hollingsworth.arsnouveau.client.renderer.entity.DummyRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.EnchantedFallingBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.EnchantedSkullRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.GiftStarbyRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.LilyRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderBlank;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderFlyingItem;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderSpell;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderSummonSkeleton;
import com.hollingsworth.arsnouveau.client.renderer.entity.StarbuncleRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.TextureVariantRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WealdWalkerRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WhirlisprigRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WildenChimeraRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WildenGuardianRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WildenHunterRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WildenStalkerRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.WixieModel;
import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.AnimSkullRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.FamiliarBookwyrmRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.FamiliarStarbyModel;
import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.FamiliarWhirlisprigRenderer;
import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.GenericFamiliarRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.AlterationTableRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArcaneCoreRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArcanePedestalRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArchwoodChestRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.BasicTurretRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.EnchantingApparatusRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.FalseweaveRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GhostweaveRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ImbuementRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.IntangibleAirRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ItemDetectorRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.LecternRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.MageBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.MirrorweaveRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.MobJarRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.PortalTileRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.PotionMelderRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.RedstoneRelayRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ReducerTurretRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.RepositoryRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.RotatingTurretRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.RuneRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ScribesRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ScryerOculusRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ScryersEyeModel;
import com.hollingsworth.arsnouveau.client.renderer.tile.SkyBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.TimerTurretRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.WhirlisprigFlowerRenderer;
import com.hollingsworth.arsnouveau.common.block.tile.MageBlockTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionMelderTile;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.items.data.BlockFillContents;
import com.hollingsworth.arsnouveau.common.items.data.PotionJarData;
import com.hollingsworth.arsnouveau.common.util.CameraUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EvokerFangsRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau", bus=EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    public static LayeredDraw.Layer cameraOverlay = (gui, tracker) -> {
        BlockEntity var10;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        BlockPos pos = mc.cameraEntity.blockPosition();
        if (!CameraUtil.isPlayerMountedOnCamera((LivingEntity)mc.player)) {
            return;
        }
        if (!((Boolean)mc.options.reducedDebugInfo().get()).booleanValue() && (var10 = level.getBlockEntity(pos)) instanceof ICameraMountable) {
            ICameraMountable be = (ICameraMountable)var10;
            Font font = Minecraft.getInstance().font;
            Options settings = Minecraft.getInstance().options;
            Component lookAround = ClientEvents.localize("ars_nouveau.camera.move", settings.keyUp.getTranslatedKeyMessage(), settings.keyLeft.getTranslatedKeyMessage(), settings.keyDown.getTranslatedKeyMessage(), settings.keyRight.getTranslatedKeyMessage());
            MutableComponent exit = Component.translatable((String)"ars_nouveau.camera.exit", (Object[])new Object[]{settings.keyShift.getTranslatedKeyMessage().getString()});
            gui.drawString(font, lookAround, 10, mc.getWindow().getGuiScaledHeight() - 40, 0xFFFFFF);
            gui.drawString(font, (Component)exit, 10, mc.getWindow().getGuiScaledHeight() - 30, 0xFFFFFF);
        }
    };

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ARCANE_PEDESTAL_TILE.get(), ArcanePedestalRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ENCHANTING_APP_TILE.get(), EnchantingApparatusRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.SCRIBES_TABLE_TILE.get(), ScribesRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.PORTAL_TILE_TYPE.get(), PortalTileRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.SKYWEAVE_TILE.get(), SkyBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.INTANGIBLE_AIR_TYPE.get(), IntangibleAirRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.IMBUEMENT_TILE.get(), ImbuementRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.POTION_MELDER_TYPE.get(), PotionMelderRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.RELAY_DEPOSIT_TILE.get(), t -> new GenericRenderer(t, "source_deposit"));
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.RELAY_WARP_TILE.get(), t -> new GenericRenderer(t, "source_warp"));
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ARCANE_RELAY_TILE.get(), t -> new GenericRenderer(t, "source_relay"));
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.RELAY_SPLITTER_TILE.get(), t -> new GenericRenderer(t, "source_splitter"));
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.BASIC_SPELL_TURRET_TILE.get(), BasicTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ROTATING_TURRET_TILE.get(), RotatingTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ENCHANTED_SPELL_TURRET_TYPE.get(), ReducerTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.TIMER_SPELL_TURRET_TILE.get(), TimerTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ARCHWOOD_CHEST_TILE.get(), ArchwoodChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.RUNE_TILE.get(), RuneRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.WHIRLISPRIG_TILE.get(), WhirlisprigFlowerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ARCANE_CORE_TILE.get(), ArcaneCoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.RELAY_COLLECTOR_TILE.get(), t -> new GenericRenderer(t, "source_collector"));
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.SCRYERS_OCULUS_TILE.get(), t -> new ScryerOculusRenderer(t, new ScryersEyeModel()));
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ARMOR_TILE.get(), AlterationTableRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.MOB_JAR_TILE.get(), MobJarRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.MIRROR_WEAVE_TILE.get(), MirrorweaveRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.GHOST_WEAVE_TILE.get(), GhostweaveRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.FALSE_WEAVE_TILE.get(), FalseweaveRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.TEMPORARY_TILE.get(), MirrorweaveRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), LecternRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.ITEM_DETECTOR_TILE.get(), ItemDetectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.REPOSITORY_TILE.get(), RepositoryRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockRegistry.REDSTONE_RELAY_TILE.get(), RedstoneRelayRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SPELL_PROJ.get(), renderManager -> new RenderSpell(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.SPELL_PROJ_ARC.get(), renderManager -> new RenderSpell(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.SPELL_PROJ_HOM.get(), renderManager -> new RenderSpell(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FOLLOW_PROJ.get(), renderManager -> new RenderBlank(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.SUMMON_SKELETON.get(), RenderSummonSkeleton::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_EVOKER_FANGS_ENTITY_TYPE.get(), EvokerFangsRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ALLY_VEX.get(), VexRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STARBUNCLE_TYPE.get(), StarbuncleRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), WhirlisprigRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get(), t -> new TextureVariantRenderer(t, new WixieModel()));
        event.registerEntityRenderer((EntityType)ModEntities.WILDEN_STALKER.get(), WildenStalkerRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WILDEN_GUARDIAN.get(), WildenGuardianRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WILDEN_HUNTER.get(), WildenHunterRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SUMMON_WOLF.get(), WolfRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SUMMON_HORSE.get(), HorseRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.LIGHTNING_ENTITY.get(), LightningBoltRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FLYING_ITEM.get(), RenderFlyingItem::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_RITUAL.get(), renderManager -> new RenderBlank(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_SPELL_ARROW.get(), TippableArrowRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get(), t -> new TextureVariantRenderer(t, new WixieModel()));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_DUMMY.get(), DummyRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_DRYGMY.get(), t -> new TextureVariantRenderer(t, new DrygmyModel()));
        event.registerEntityRenderer((EntityType)ModEntities.ORBIT_SPELL.get(), renderManager -> new RenderBlank(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.WILDEN_BOSS.get(), WildenChimeraRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_CHIMERA_SPIKE.get(), ChimeraProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FAMILIAR_STARBUNCLE.get(), t -> new GenericFamiliarRenderer(t, new FamiliarStarbyModel()));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FAMILIAR_DRYGMY.get(), t -> new GenericFamiliarRenderer(t, new DrygmyModel()));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FAMILIAR_SYLPH.get(), FamiliarWhirlisprigRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FAMILIAR_WIXIE.get(), t -> new GenericFamiliarRenderer(t, new WixieModel()));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get(), BookwyrmRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FAMILIAR_AMETHYST_GOLEM.get(), t -> new GenericFamiliarRenderer(t, new AmethystGolemModel()));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FAMILIAR_BOOKWYRM.get(), FamiliarBookwyrmRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.LINGER_SPELL.get(), renderManager -> new RenderBlank(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_CASCADING_WEALD.get(), v -> new WealdWalkerRenderer(v, "cascading_weald"));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_BLAZING_WEALD.get(), v -> new WealdWalkerRenderer(v, "blazing_weald"));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_FLOURISHING_WEALD.get(), v -> new WealdWalkerRenderer(v, "flourishing_weald"));
        event.registerEntityRenderer((EntityType)ModEntities.ENTITY_VEXING_WEALD.get(), v -> new WealdWalkerRenderer(v, "vexing_weald"));
        event.registerEntityRenderer((EntityType)ModEntities.AMETHYST_GOLEM.get(), AmethystGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SCRYER_CAMERA.get(), renderManager -> new RenderBlank(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.ENCHANTED_FALLING_BLOCK.get(), EnchantedFallingBlockRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ICE_SHARD.get(), EnchantedFallingBlockRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENCHANTED_MAGE_BLOCK.get(), MageBlockRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENCHANTED_HEAD_BLOCK.get(), EnchantedSkullRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.GIFT_STARBY.get(), GiftStarbyRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ANIMATED_BLOCK.get(), AnimBlockRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ANIMATED_HEAD.get(), AnimSkullRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CINDER.get(), CinderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WALL_SPELL.get(), renderManager -> new RenderBlank(renderManager, ArsNouveau.prefix("textures/entity/spell_proj.png")));
        event.registerEntityRenderer((EntityType)ModEntities.LILY.get(), LilyRenderer::new);
    }

    @SubscribeEvent
    public static void registerMenu(RegisterMenuScreensEvent event) {
        event.register((MenuType)MenuRegistry.STORAGE.get(), CraftingTerminalScreen::new);
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ArsNouveau.prefix("scry_camera"), cameraOverlay);
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ArsNouveau.prefix("tooltip"), GuiEntityInfoHUD.OVERLAY);
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ArsNouveau.prefix("mana_hud"), GuiManaHUD.OVERLAY);
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ArsNouveau.prefix("spell_hud"), GuiSpellHUD.OVERLAY);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ItemsRegistry.ENCHANTERS_SHIELD.get()), (ResourceLocation)ArsNouveau.prefix("blocking"), (item, resourceLocation, livingEntity, arg4) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == item ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemsRegistry.DOWSING_ROD.get()), (ResourceLocation)ArsNouveau.prefix("uses"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

                public float unclampedCall(ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
                    return switch (pStack.getDamageValue()) {
                        case 1 -> 0.75f;
                        case 2 -> 0.5f;
                        case 3 -> 0.25f;
                        default -> 1.0f;
                    };
                }
            });
            ItemProperties.register((Item)BlockRegistry.POTION_JAR.asItem(), (ResourceLocation)ArsNouveau.prefix("amount"), (stack, level, entity, seed) -> {
                int amount = ((PotionJarData)stack.getOrDefault(DataComponentRegistry.POTION_JAR, (Object)new PotionJarData(0, PotionContents.EMPTY, false))).fill();
                return (float)amount / 10000.0f;
            });
            ItemProperties.register((Item)BlockRegistry.SOURCE_JAR.asItem(), (ResourceLocation)ArsNouveau.prefix("source"), (stack, level, entity, seed) -> {
                int amount = BlockFillContents.get(stack);
                return (float)amount / 10000.0f;
            });
        });
    }

    @SubscribeEvent
    public static void initBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, reader, pos, tIndex) -> {
            int n;
            BlockEntity patt0$temp;
            if (reader != null && pos != null && (patt0$temp = reader.getBlockEntity(pos)) instanceof PotionJarTile) {
                PotionJarTile jarTile = (PotionJarTile)patt0$temp;
                n = jarTile.getColor();
            } else {
                n = -1;
            }
            return n;
        }, new Block[]{(Block)BlockRegistry.POTION_JAR.get()});
        event.register((state, reader, pos, tIndex) -> {
            int n;
            BlockEntity patt0$temp;
            if (reader != null && pos != null && (patt0$temp = reader.getBlockEntity(pos)) instanceof PotionMelderTile) {
                PotionMelderTile melderTile = (PotionMelderTile)patt0$temp;
                n = melderTile.getColor();
            } else {
                n = -1;
            }
            return n;
        }, new Block[]{(Block)BlockRegistry.POTION_MELDER.get()});
        event.register((state, reader, pos, tIndex) -> {
            int n;
            BlockEntity patt0$temp;
            if (reader != null && pos != null && (patt0$temp = reader.getBlockEntity(pos)) instanceof MageBlockTile) {
                MageBlockTile mageBlockTile = (MageBlockTile)patt0$temp;
                n = mageBlockTile.color.getColor();
            } else {
                n = -1;
            }
            return n;
        }, new Block[]{(Block)BlockRegistry.MAGE_BLOCK.get()});
    }

    @SubscribeEvent
    public static void initItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromFlask(stack), new ItemLike[]{ItemsRegistry.POTION_FLASK});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromFlask(stack), new ItemLike[]{ItemsRegistry.POTION_FLASK_EXTEND_TIME});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromFlask(stack), new ItemLike[]{ItemsRegistry.POTION_FLASK_AMPLIFY});
        event.register((stack, color) -> color > 0 ? -1 : new ParticleColor(200, 0, 200).getColor(), new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ArsNouveau.prefix("potion_melder"))});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.SORCERER_ROBES});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.SORCERER_BOOTS});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.SORCERER_HOOD});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.SORCERER_LEGGINGS});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.ARCANIST_ROBES});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.ARCANIST_BOOTS});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.ARCANIST_HOOD});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.ARCANIST_LEGGINGS});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.BATTLEMAGE_ROBES});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.BATTLEMAGE_BOOTS});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.BATTLEMAGE_HOOD});
        event.register((stack, color) -> color > 0 ? -1 : ClientHandler.colorFromArmor(stack), new ItemLike[]{ItemsRegistry.BATTLEMAGE_LEGGINGS});
        event.register((stack, color) -> {
            if (color == 1 && SpellCasterRegistry.from(stack) != null) {
                return FastColor.ABGR32.opaque((int)SpellCasterRegistry.from(stack).getColor().getColor());
            }
            return -1;
        }, new ItemLike[]{ItemsRegistry.SPELL_PARCHMENT});
        event.register((stack, color) -> {
            PotionJarData contents = (PotionJarData)stack.get(DataComponentRegistry.POTION_JAR);
            if (contents == null) {
                return -1;
            }
            return contents.contents().getColor();
        }, new ItemLike[]{BlockRegistry.POTION_JAR});
    }

    public static int colorFromArmor(ItemStack stack) {
        ArmorPerkHolder holder = PerkUtil.getPerkHolder(stack);
        if (!(holder instanceof ArmorPerkHolder)) {
            return FastColor.ABGR32.opaque((int)DyeColor.PURPLE.getTextColor());
        }
        ArmorPerkHolder armorPerkHolder = holder;
        return FastColor.ABGR32.opaque((int)DyeColor.byName((String)armorPerkHolder.getColor(), (DyeColor)DyeColor.PURPLE).getTextColor());
    }

    public static int colorFromFlask(ItemStack stack) {
        PotionContents contents = PotionUtil.getContents(stack);
        IPotionProvider provider = PotionProviderRegistry.from(stack);
        if (provider != null) {
            return provider.usesRemaining(stack) <= 0 ? 0 : provider.getPotionData(stack).getColor();
        }
        return contents == PotionContents.EMPTY ? -1 : contents.getColor();
    }
}

