/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.client.CosmeticRenderUtil;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.client.registry.ShaderRegistry;
import com.hollingsworth.arsnouveau.client.renderer.entity.StarbuncleModel;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class StarbuncleRenderer
extends GeoEntityRenderer<Starbuncle> {
    public static MultiBufferSource.BufferSource cosmeticBuffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));

    public StarbuncleRenderer(EntityRendererProvider.Context manager) {
        super(manager, (GeoModel)new StarbuncleModel());
    }

    public void renderRecursively(PoseStack stack, Starbuncle animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        ICosmeticItem cosmetic;
        Item item;
        super.renderRecursively(stack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        if (bone.getName().equals("item")) {
            stack.pushPose();
            RenderUtil.translateToPivotPoint((PoseStack)stack, (GeoBone)bone);
            stack.translate(0.0, -0.1, 0.0);
            stack.scale(0.75f, 0.75f, 0.75f);
            ItemStack itemstack = animatable.getHeldStack();
            if (animatable.dynamicBehavior != null) {
                itemstack = animatable.dynamicBehavior.getStackForRender();
            }
            if (!itemstack.isEmpty()) {
                Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, stack, bufferSource, animatable.level, (int)animatable.getOnPos().asLong());
            }
            stack.popPose();
        }
        if ((item = animatable.getCosmeticItem().getItem()) instanceof ICosmeticItem && (cosmetic = (ICosmeticItem)item).getBone().equals(bone.getName())) {
            CosmeticRenderUtil.renderCosmetic(bone, stack, (MultiBufferSource)cosmeticBuffer, animatable, packedLight);
            cosmeticBuffer.endBatch();
        }
    }

    public ResourceLocation getTextureLocation(Starbuncle entity) {
        return entity.getTexture(entity);
    }

    public RenderType getRenderType(Starbuncle animatable, ResourceLocation textureLocation, @Nullable MultiBufferSource bufferSource, float partialTick) {
        if (animatable.getName().getString().equals("Splonk")) {
            return ShaderRegistry.blamed(textureLocation, true);
        }
        if (animatable.getName().getString().equals("Bailey")) {
            return ShaderRegistry.rainbowEntity(textureLocation, ArsNouveau.prefix("textures/entity/starbuncle_mask.png"), true);
        }
        if (animatable.getName().getString().equals("Gootastic")) {
            return RenderType.entityTranslucent((ResourceLocation)textureLocation);
        }
        return RenderType.entityCutoutNoCull((ResourceLocation)textureLocation);
    }
}

