/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.ANGeoModel;
import com.hollingsworth.arsnouveau.common.items.SpellBow;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.Color;

public class SpellBowRenderer
extends GeoItemRenderer<SpellBow> {
    public SpellBowRenderer() {
        super(new ANGeoModel("geo/spellbow.geo.json", "textures/item/spellbow.png", "animations/wand_animation.json"));
    }

    public void renderRecursively(PoseStack poseStack, SpellBow animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (bone.getName().equals("gem")) {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        } else {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, Color.WHITE.argbInt());
        }
    }

    public Color getRenderColor(SpellBow animatable, float partialTick, int packedLight) {
        ParticleColor color = ParticleColor.defaultParticleColor();
        AbstractCaster<?> caster = SpellCasterRegistry.from(this.currentItemStack);
        if (caster != null) {
            color = caster.getColor();
        }
        return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.75f);
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext transformType, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int p_239207_6_) {
        if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            LocalPlayer player = Minecraft.getInstance().player;
            Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
            Vec3 look = player.getLookAngle();
            Vec3 right = new Vec3(-look.z, 0.0, look.x).normalize();
            Vec3 forward = look;
            Vec3 down = right.cross(forward);
            right = right.scale(0.2 - (double)player.attackAnim);
            forward = forward.scale((double)0.45f);
            down = down.scale(-0.1 - (double)player.attackAnim);
            Vec3 laserPos = playerPos.add(right);
            laserPos = laserPos.add(forward);
            laserPos = laserPos.add(down);
            AbstractCaster<?> tool = SpellCasterRegistry.from(itemStack);
            int timeHeld = 72000 - Minecraft.getInstance().player.getUseItemRemainingTicks();
            if (timeHeld > 0 && timeHeld != 72000) {
                float scaleAge = (float)ParticleUtil.inRange(0.05, 0.1);
                if (player.level.random.nextInt(6) == 0) {
                    for (int i = 0; i < 1; ++i) {
                        Vec3 particlePos = new Vec3(laserPos.x, laserPos.y, laserPos.z);
                        particlePos = particlePos.add(ParticleUtil.pointInSphere().scale((double)0.3f));
                        player.level.addParticle(ParticleLineData.createData(tool.getColor(), scaleAge, 5 + player.level.random.nextInt(20)), particlePos.x(), particlePos.y(), particlePos.z(), laserPos.x(), laserPos.y(), laserPos.z());
                    }
                }
            }
        }
        super.renderByItem(itemStack, transformType, stack, bufferIn, combinedLightIn, p_239207_6_);
    }

    public void renderFinal(PoseStack poseStack, SpellBow animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTicks, int packedLight, int packedOverlay, int color) {
        int timeHeld;
        GeoBone top = (GeoBone)model.getBone("bow_top").get();
        GeoBone gem = (GeoBone)model.getBone("gem").get();
        GeoBone bottom = (GeoBone)model.getBone("bow_bot").get();
        double ticks = animatable.getTick(animatable);
        float outerAngle = (float)((ticks + (double)partialTicks) / 10.0 % 360.0);
        top.setRotZ((float)Math.toRadians(-10.0));
        top.setRotY(0.0f);
        top.setRotX(0.0f);
        bottom.setRotZ((float)Math.toRadians(10.0));
        bottom.setRotY(0.0f);
        bottom.setRotX((float)Math.toRadians(-180.0));
        if (Minecraft.getInstance().player.getMainHandItem().equals(this.currentItemStack) && (timeHeld = 72000 - Minecraft.getInstance().player.getUseItemRemainingTicks()) != 0 && timeHeld != 72000) {
            top.setRotZ((float)(Math.toRadians(-10.0) - Math.toRadians(timeHeld) * 2.0));
            bottom.setRotZ((float)(Math.toRadians(-10.0) + Math.toRadians(timeHeld) * 2.0));
            outerAngle = (float)((ticks + (double)partialTicks) / 5.0 % 360.0);
            if (timeHeld >= 19) {
                top.setRotZ((float)(Math.toRadians(-10.0) - Math.toRadians(19.0) * 2.0));
                bottom.setRotZ((float)(Math.toRadians(-10.0) + Math.toRadians(19.0) * 2.0));
                outerAngle = (float)((ticks + (double)partialTicks) / 3.0 % 360.0);
            }
        }
        gem.setRotX(outerAngle);
        gem.setRotY(outerAngle);
    }

    public RenderType getRenderType(SpellBow animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }
}

