/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.google.common.collect.Maps;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AlterationTile;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.items.data.StackPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class AlterationTableRenderer
extends GeoBlockRenderer<AlterationTile> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    public final ArmorStandArmorModel innerModel;
    public final ArmorStandArmorModel outerModel;
    private final TextureAtlas armorTrimAtlas;

    public AlterationTableRenderer(BlockEntityRendererProvider.Context p_i226006_1_) {
        super((GeoModel)new GenericModel("alteration_table").withEmptyAnim());
        this.innerModel = new ArmorStandArmorModel(p_i226006_1_.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.outerModel = new ArmorStandArmorModel(p_i226006_1_.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.armorTrimAtlas = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
    }

    public void renderArmorStack(AlterationTile tile, PoseStack matrixStack, float ticks, MultiBufferSource iRenderTypeBuffer, int packedLightIn, int packedOverlayIn) {
        matrixStack.pushPose();
        BlockState state = tile.getLevel().getBlockState(tile.getBlockPos());
        if (!(state.getBlock() instanceof AlterationTable)) {
            return;
        }
        ItemStack stack = tile.armorStack;
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            matrixStack.translate(-2.1, 3.3, 0.0);
            double yOffset = Mth.smoothstepDerivative((double)((Math.sin(((float)ClientInfo.ticksInGame + ticks) / 20.0f) + 1.0) / 2.0)) * 0.0625;
            if (tile.newPerkTimer >= 0) {
                yOffset = 0.0;
                float percentage = (float)Mth.abs((int)(tile.newPerkTimer - 20)) / 20.0f;
                double smooooooooth = Mth.smoothstep((double)percentage);
                double perkYOffset = 0.625 - smooooooooth * 0.625;
                matrixStack.mulPose(Axis.YP.rotationDegrees((float)(Mth.smoothstep((double)((float)tile.newPerkTimer / 40.0f)) * 360.0)));
                matrixStack.translate(0.0, perkYOffset, 0.0);
            }
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            matrixStack.translate(0.0, yOffset + (double)this.rotForSlot(armorItem.getEquipmentSlot()), 0.0);
            this.renderArmorPiece(tile, stack, matrixStack, iRenderTypeBuffer, packedLightIn, this.getArmorModel(armorItem.getEquipmentSlot()));
        } else {
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLightIn, packedOverlayIn, matrixStack, iRenderTypeBuffer, tile.getLevel(), (int)tile.getBlockPos().asLong());
        }
        matrixStack.popPose();
    }

    public void renderPerks(AlterationTile tile, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int packedLightIn, int packedOverlayIn) {
        if (tile.perkList.isEmpty()) {
            return;
        }
        for (int i = 0; i < Math.min(3, tile.perkList.size()); ++i) {
            ItemStack perkStack = tile.perkList.get(i);
            if (perkStack.isEmpty()) continue;
            matrixStack.pushPose();
            matrixStack.translate(-0.25, 0.74 - 0.175 * (double)i, -0.3 - 0.175 * (double)i);
            GeoBone bone = (GeoBone)this.model.getBone("display").get();
            if (bone.getRotZ() != 0.0f) {
                matrixStack.mulPose(Axis.ZP.rotation(-bone.getRotZ()));
            }
            if (bone.getRotY() != 0.0f) {
                matrixStack.mulPose(Axis.YP.rotation(-bone.getRotY()));
            }
            if (bone.getRotX() != 0.0f) {
                matrixStack.mulPose(Axis.XP.rotation(-bone.getRotX()));
            }
            GeoBone locBone = (GeoBone)this.model.getBone("top_" + (i + 1)).get();
            RenderUtil.translateToPivotPoint((PoseStack)matrixStack, (GeoBone)locBone);
            matrixStack.scale(0.18f, 0.18f, 0.18f);
            Minecraft.getInstance().getItemRenderer().renderStatic(perkStack, ItemDisplayContext.FIXED, packedLightIn, packedOverlayIn, matrixStack, iRenderTypeBuffer, tile.getLevel(), (int)tile.getBlockPos().asLong());
            matrixStack.popPose();
        }
    }

    public float rotForSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> 0.3f;
            case EquipmentSlot.LEGS -> -0.2f;
            case EquipmentSlot.FEET -> -0.6f;
            default -> 0.0f;
        };
    }

    private ArmorStandArmorModel getArmorModel(EquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private void renderArmorPiece(AlterationTile tile, ItemStack itemstack, PoseStack pPoseStack, MultiBufferSource pBuffer, int packedLightIn, ArmorStandArmorModel armorModel) {
        Item item = itemstack.getItem();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armoritem = (ArmorItem)item;
        EquipmentSlot pSlot = armoritem.getEquipmentSlot();
        this.setPartVisibility((HumanoidModel)armorModel, pSlot);
        Model model = ClientHooks.getArmorModel((LivingEntity)Minecraft.getInstance().player, (ItemStack)itemstack, (EquipmentSlot)pSlot, (HumanoidModel)armorModel);
        boolean innerModel = this.usesInnerModel(pSlot);
        DyedItemColor dyeColor = (DyedItemColor)itemstack.get(DataComponents.DYED_COLOR);
        int color = dyeColor != null ? FastColor.ABGR32.opaque((int)dyeColor.rgb()) : -1;
        ArmorMaterial armormaterial = (ArmorMaterial)armoritem.getMaterial().value();
        for (ArmorMaterial.Layer armormaterial$layer : armormaterial.layers()) {
            int j = armormaterial$layer.dyeable() ? color : -1;
            ResourceLocation texture = ClientHooks.getArmorTexture((Entity)Minecraft.getInstance().player, (ItemStack)itemstack, (ArmorMaterial.Layer)armormaterial$layer, (boolean)innerModel, (EquipmentSlot)pSlot);
            this.renderModel(pPoseStack, pBuffer, packedLightIn, model, j, texture);
        }
        ArmorTrim armortrim = (ArmorTrim)itemstack.get(DataComponents.TRIM);
        if (armortrim != null) {
            this.renderTrim((Holder<ArmorMaterial>)armoritem.getMaterial(), pPoseStack, pBuffer, packedLightIn, armortrim, model, innerModel);
        }
        if (itemstack.hasFoil()) {
            this.renderGlint(pPoseStack, pBuffer, packedLightIn, model);
        }
    }

    private void renderModel(PoseStack p_289664_, MultiBufferSource p_289689_, int p_289681_, Model p_289658_, int p_350798_, ResourceLocation p_324344_) {
        VertexConsumer vertexconsumer = p_289689_.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)p_324344_));
        p_289658_.renderToBuffer(p_289664_, vertexconsumer, p_289681_, OverlayTexture.NO_OVERLAY, p_350798_);
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    private void renderTrim(Holder<ArmorMaterial> p_323506_, PoseStack p_289687_, MultiBufferSource p_289643_, int p_289683_, ArmorTrim p_289692_, Model p_289663_, boolean p_289651_) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.getSprite(p_289651_ ? p_289692_.innerTexture(p_323506_) : p_289692_.outerTexture(p_323506_));
        VertexConsumer vertexconsumer = textureatlassprite.wrap(p_289643_.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)p_289692_.pattern().value()).decal())));
        p_289663_.renderToBuffer(p_289687_, vertexconsumer, p_289683_, OverlayTexture.NO_OVERLAY);
    }

    private void renderGlint(PoseStack p_289673_, MultiBufferSource p_289654_, int p_289649_, Model p_289659_) {
        p_289659_.renderToBuffer(p_289673_, p_289654_.getBuffer(RenderType.armorEntityGlint()), p_289649_, OverlayTexture.NO_OVERLAY);
    }

    public void actuallyRender(PoseStack stack, AlterationTile tile, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (tile.getLevel().getBlockState(tile.getBlockPos()).getBlock() != BlockRegistry.ALTERATION_TABLE.get()) {
            return;
        }
        if (tile.getLevel().getBlockState(tile.getBlockPos()).getValue((Property)AlterationTable.PART) != ThreePartBlock.HEAD) {
            return;
        }
        Direction direction = (Direction)tile.getLevel().getBlockState(tile.getBlockPos()).getValue((Property)AlterationTable.FACING);
        stack.pushPose();
        if (direction == Direction.NORTH) {
            stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            stack.translate(1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.SOUTH) {
            stack.mulPose(Axis.YP.rotationDegrees(270.0f));
            stack.translate(-1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.WEST) {
            stack.mulPose(Axis.YP.rotationDegrees(270.0f));
            stack.translate(0.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.EAST) {
            stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            stack.translate(0.0f, 0.0f, 1.0f);
        }
        this.renderSlate(model, (AlterationTile)this.animatable);
        super.actuallyRender(stack, (BlockEntity)tile, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        stack.popPose();
    }

    public void render(AlterationTile animatable, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render((BlockEntity)animatable, partialTick, stack, bufferSource, packedLight, packedOverlay);
        if (animatable.getLevel().getBlockState(animatable.getBlockPos()).getBlock() != BlockRegistry.ALTERATION_TABLE.get()) {
            return;
        }
        if (animatable.getLevel().getBlockState(animatable.getBlockPos()).getValue((Property)AlterationTable.PART) != ThreePartBlock.HEAD) {
            return;
        }
        Direction direction = (Direction)animatable.getLevel().getBlockState(animatable.getBlockPos()).getValue((Property)AlterationTable.FACING);
        Vector3d perkTranslate = new Vector3d(0.0, 0.0, 0.0);
        Quaternionf perkQuat = Axis.YP.rotationDegrees(-90.0f);
        if (direction == Direction.NORTH) {
            perkQuat = Axis.YP.rotationDegrees(-90.0f);
            perkTranslate = new Vector3d(1.55, 0.0, -0.5);
        }
        if (direction == Direction.SOUTH) {
            perkQuat = Axis.YP.rotationDegrees(90.0f);
            perkTranslate = new Vector3d(0.5, 0.0, 0.5);
        }
        if (direction == Direction.WEST) {
            perkQuat = Axis.YP.rotationDegrees(0.0f);
            perkTranslate = new Vector3d(1.5, 0.0, 0.5);
        }
        if (direction == Direction.EAST) {
            perkQuat = Axis.YP.rotationDegrees(180.0f);
            perkTranslate = new Vector3d(0.5, 0.0, -0.5);
        }
        double ticks = animatable.getTick(animatable);
        stack.pushPose();
        stack.mulPose(perkQuat);
        stack.translate(perkTranslate.x, perkTranslate.y + 0.2, perkTranslate.z);
        if (!(animatable.armorStack.getItem() instanceof ArmorItem)) {
            stack.scale(0.75f, 0.75f, 0.75f);
            stack.translate(-1.5, 1.95, 0.0);
        }
        this.renderArmorStack(animatable, stack, (float)ticks, bufferSource, packedLight, packedOverlay);
        stack.popPose();
        stack.pushPose();
        stack.mulPose(perkQuat);
        stack.translate(perkTranslate.x, perkTranslate.y, perkTranslate.z);
        this.renderPerks(animatable, stack, bufferSource, packedLight, packedOverlay);
        stack.popPose();
    }

    public void renderSlate(BakedGeoModel model, AlterationTile tile) {
        String[] rowNames = new String[]{"top", "mid", "bot"};
        if (tile.armorStack.isEmpty()) {
            for (String s2 : rowNames) {
                this.setSlateRow(model, s2, 0);
            }
            return;
        }
        ArmorPerkHolder armorPerkHolder = PerkUtil.getPerkHolder(tile.armorStack);
        if (!(armorPerkHolder instanceof StackPerkHolder)) {
            return;
        }
        ArmorPerkHolder armorPerkHolder2 = armorPerkHolder;
        List<PerkSlot> perks = armorPerkHolder2.getSlotsForTier(tile.armorStack);
        for (int i = 0; i < Math.min(perks.size(), rowNames.length); ++i) {
            PerkSlot perkSlot = perks.get(i);
            this.setSlateRow(model, rowNames[i], perkSlot.value());
        }
        List<String> remainingRows = List.of(rowNames);
        remainingRows.subList(perks.size(), remainingRows.size()).forEach(s -> this.setSlateRow(model, (String)s, 0));
    }

    public void setSlateRow(BakedGeoModel model, String loc, int tier) {
        for (int i = 0; i < 4; ++i) {
            if (tier != i) {
                model.getBone(loc + "_" + i).ifPresent(bone -> bone.setHidden(true));
                continue;
            }
            model.getBone(loc + "_" + i).ifPresent(bone -> bone.setHidden(false));
        }
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(new GenericModel("alteration_table").withEmptyAnim());
    }

    public RenderType getRenderType(AlterationTile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    protected void setPartVisibility(HumanoidModel pModel, EquipmentSlot pSlot) {
        pModel.setAllVisible(false);
        switch (pSlot) {
            case HEAD: {
                pModel.head.visible = true;
                pModel.hat.visible = true;
                break;
            }
            case CHEST: {
                pModel.body.visible = true;
                pModel.rightArm.visible = true;
                pModel.leftArm.visible = true;
                break;
            }
            case LEGS: {
                pModel.body.visible = true;
                pModel.rightLeg.visible = true;
                pModel.leftLeg.visible = true;
                break;
            }
            case FEET: {
                pModel.rightLeg.visible = true;
                pModel.leftLeg.visible = true;
            }
        }
    }

    public boolean shouldRenderOffScreen(AlterationTile pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(AlterationTile blockEntity) {
        return AABB.INFINITE;
    }
}

