/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.advancement;

import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ANCriteriaTriggers {
    public static final DeferredRegister<CriterionTrigger<?>> TRIGGERS = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"ars_nouveau");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> POOF_MOB = ANCriteriaTriggers.register("poof_mob");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> FAMILIAR = ANCriteriaTriggers.register("familiar");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> CHIMERA_EXPLOSION = ANCriteriaTriggers.register("chimera_explosion");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> CREATE_PORTAL = ANCriteriaTriggers.register("portals");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> PRISMATIC = ANCriteriaTriggers.register("prismatic");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> SHRUNK_STARBY = ANCriteriaTriggers.register("shrunk_starby");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> CAUGHT_LIGHTNING = ANCriteriaTriggers.register("catch_lightning");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> TIME_IN_BOTTLE = ANCriteriaTriggers.register("time_in_bottle");

    public static void rewardNearbyPlayers(PlayerTrigger criteria, ServerLevel level, BlockPos pos, int radius) {
        AABB aabb = new AABB(pos).inflate((double)radius);
        for (ServerPlayer player : level.players()) {
            if (!aabb.contains(player.getX(), player.getY(), player.getZ())) continue;
            criteria.trigger(player);
        }
    }

    public static <T extends CriterionTrigger<?>> DeferredHolder<CriterionTrigger<?>, PlayerTrigger> register(String pName) {
        return ANCriteriaTriggers.register(pName, new PlayerTrigger());
    }

    public static <T extends CriterionTrigger<?>> DeferredHolder<CriterionTrigger<?>, T> register(String pName, T pTrigger) {
        return TRIGGERS.register(pName, () -> pTrigger);
    }

    public static void init() {
    }

    public static Criterion<?> createCriterion(DeferredHolder<CriterionTrigger<?>, PlayerTrigger> holder) {
        return ((PlayerTrigger)holder.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()));
    }
}

