/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.block.TableBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AlterationTile;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.items.data.StackPerkHolder;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AlterationTable
extends TableBlock {
    public static VoxelShape SOUTH_OTHER = Shapes.or((VoxelShape)Block.box((double)3.4, (double)0.0, (double)1.0, (double)7.333333, (double)1.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.333333, (double)0.0, (double)1.0, (double)12.666667, (double)4.5, (double)17.0), Block.box((double)12.666667, (double)4.0, (double)1.0, (double)14.0, (double)10.0, (double)17.0)});
    public static VoxelShape NORTH_OTHER = Shapes.or((VoxelShape)Block.box((double)8.666667, (double)0.0, (double)-1.0, (double)12.6, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.333333, (double)0.0, (double)-1.0, (double)8.666667, (double)4.5, (double)15.0), Block.box((double)2.0, (double)4.0, (double)-1.0, (double)3.333333, (double)10.0, (double)15.0)});
    public static VoxelShape EAST_OTHER = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)8.666667, (double)17.0, (double)1.0, (double)12.6), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)3.333333, (double)17.0, (double)4.5, (double)8.666667), Block.box((double)1.0, (double)4.0, (double)2.0, (double)17.0, (double)10.0, (double)3.333333)});
    public static VoxelShape WEST_OTHER = Shapes.or((VoxelShape)Block.box((double)-1.0, (double)0.0, (double)3.4, (double)15.0, (double)1.0, (double)7.333333), (VoxelShape[])new VoxelShape[]{Block.box((double)-1.0, (double)0.0, (double)7.333333, (double)15.0, (double)4.5, (double)12.666667), Block.box((double)-1.0, (double)4.0, (double)12.666667, (double)15.0, (double)10.0, (double)14.0)});

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (world.isClientSide || handIn != InteractionHand.MAIN_HAND || !((blockEntity = world.getBlockEntity(pos)) instanceof AlterationTile)) {
            return ItemInteractionResult.SUCCESS;
        }
        AlterationTile tile = (AlterationTile)blockEntity;
        ItemStack stack = player.getMainHandItem();
        if (tile.isMasterTile()) {
            ArmorPerkHolder holder = PerkUtil.getPerkHolder(stack);
            if (holder instanceof StackPerkHolder) {
                if (tile.armorStack.isEmpty()) {
                    tile.setArmorStack(stack, player);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (stack.isEmpty() && !tile.armorStack.isEmpty()) {
                tile.removeArmorStack(player);
                return ItemInteractionResult.SUCCESS;
            }
        } else if (state.getValue((Property)PART) == ThreePartBlock.OTHER) {
            this.useItemOn(pStack, world.getBlockState(pos.below()), world, pos.below(), player, handIn, hit);
        } else {
            if ((tile = tile.getLogicTile()) == null) {
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.isEmpty()) {
                tile.removePerk(player);
                return ItemInteractionResult.SUCCESS;
            }
            if (!(stack.getItem() instanceof PerkItem)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.perk.not_perk"));
                return ItemInteractionResult.SUCCESS;
            }
            tile.addPerkStack(stack, player);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new AlterationTile(pPos, pState);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof AlterationTile) {
            AlterationTile tile = (AlterationTile)blockEntity;
            tile.dropItems();
        }
        return state;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        ThreePartBlock partBlock = (ThreePartBlock)((Object)state.getValue((Property)PART));
        if (partBlock != ThreePartBlock.OTHER) {
            return super.getShape(state, getter, pos, context);
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (direction == Direction.SOUTH) {
            return SOUTH_OTHER;
        }
        if (direction == Direction.NORTH) {
            return NORTH_OTHER;
        }
        if (direction == Direction.EAST) {
            return EAST_OTHER;
        }
        if (direction == Direction.WEST) {
            return WEST_OTHER;
        }
        return super.getShape(state, getter, pos, context);
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        ThreePartBlock partBlock = (ThreePartBlock)((Object)pState.getValue((Property)PART));
        if (partBlock != ThreePartBlock.OTHER) {
            return super.getCollisionShape(pState, pLevel, pPos, pContext);
        }
        return Shapes.empty();
    }

    @Override
    public BlockState tearDown(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        BlockEntity entity;
        if (!world.isClientSide() && (entity = world.getBlockEntity(pos)) instanceof AlterationTile) {
            AlterationTile tile = (AlterationTile)entity;
            tile.dropItems();
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity entity, ItemStack stack) {
        if (world.isClientSide) {
            return;
        }
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
        world.setBlock(blockpos, (BlockState)state.setValue((Property)PART, (Comparable)((Object)ThreePartBlock.HEAD)), 3);
        BlockPos lecternPos = pos.relative(Direction.UP);
        world.setBlock(lecternPos, (BlockState)state.setValue((Property)PART, (Comparable)((Object)ThreePartBlock.OTHER)), 3);
        world.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        List<Direction> connectedDirs = this.getConnectedDirections(state);
        if (connectedDirs.contains(direction)) {
            for (Direction dir : connectedDirs) {
                if (world.getBlockState(pos.relative(dir)).getBlock() == this) continue;
                return this.tearDown(state, dir, state2, world, pos, pos2);
            }
        }
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    public List<Direction> getConnectedDirections(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch ((ThreePartBlock)((Object)state.getValue((Property)PART))) {
            case ThreePartBlock.HEAD -> List.of(direction.getOpposite());
            case ThreePartBlock.FOOT -> List.of(direction, Direction.UP);
            case ThreePartBlock.OTHER -> List.of(Direction.DOWN);
            default -> List.of();
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        BlockState horizontalState = context.getLevel().getBlockState(blockpos1);
        BlockState aboveState = context.getLevel().getBlockState(blockpos.above());
        return horizontalState.canBeReplaced(context) && aboveState.canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }
}

