/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ImbuementBlock
extends TickableModBlock {
    public ImbuementBlock() {
        super(ImbuementBlock.defaultProperties().noOcclusion());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ImbuementTile(pos, state);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (!(blockEntity instanceof ImbuementTile)) {
            return ItemInteractionResult.SUCCESS;
        }
        ImbuementTile tile = (ImbuementTile)blockEntity;
        if (worldIn.isClientSide || handIn != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.SUCCESS;
        }
        if (tile.stack.isEmpty() && !player.getItemInHand(handIn).isEmpty()) {
            tile.stack = player.getItemInHand(handIn).copy();
            RecipeHolder<? extends ImbuementRecipe> recipe = tile.getRecipeNow();
            if (recipe == null) {
                ArrayList<ColorPos> colorPos = new ArrayList<ColorPos>();
                for (BlockPos pedPos : tile.getNearbyPedestals()) {
                    BlockEntity blockEntity2 = worldIn.getBlockEntity(pedPos);
                    if (!(blockEntity2 instanceof ArcanePedestalTile)) continue;
                    ArcanePedestalTile pedestalTile = (ArcanePedestalTile)blockEntity2;
                    colorPos.add(ColorPos.centeredAbove(pedPos));
                }
                Networking.sendToNearbyClient(worldIn, tile.getBlockPos(), (CustomPacketPayload)new HighlightAreaPacket(colorPos, 60));
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.imbuement.norecipe"));
                tile.stack = ItemStack.EMPTY;
            } else {
                tile.stack = player.getInventory().removeItem(player.getInventory().selected, 1);
                PortUtil.sendMessageNoSpam((Entity)player, ((ImbuementRecipe)recipe.value()).getCraftingStartedText(tile));
                tile.updateBlock();
            }
        } else {
            ItemEntity item = new ItemEntity(worldIn, player.getX(), player.getY(), player.getZ(), tile.stack.copy());
            worldIn.addFreshEntity((Entity)item);
            tile.stack = ItemStack.EMPTY;
            tile.stack = player.getInventory().getSelected().copy();
            RecipeHolder<? extends ImbuementRecipe> recipe = tile.getRecipeNow();
            tile.stack = recipe != null ? player.getInventory().removeItem(player.getInventory().selected, 1) : ItemStack.EMPTY;
            tile.draining = false;
            tile.updateBlock();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(worldIn, pos, state, player);
        if (!(worldIn.getBlockEntity(pos) instanceof ImbuementTile)) {
            return state;
        }
        ItemStack stack = ((ImbuementTile)worldIn.getBlockEntity((BlockPos)pos)).stack;
        worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack.copy()));
        ((ImbuementTile)worldIn.getBlockEntity((BlockPos)pos)).stack = ItemStack.EMPTY;
        return state;
    }
}

