/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.registry.JarBehaviorRegistry;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.items.MobJarItem;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobJar
extends TickableModBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final Property<Integer> LIGHT_LEVEL = IntegerProperty.create((String)"level", (int)0, (int)15);
    public static final Property<Boolean> POWERED = BlockStateProperties.POWERED;
    private static BlockBehaviour.Properties props = MobJar.defaultProperties().noOcclusion().lightLevel(state -> (Integer)state.getValue(LIGHT_LEVEL));
    public static final VoxelShape shape = Stream.of(Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public MobJar() {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).setValue(POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack held;
        MobJarTile tile = (MobJarTile)pLevel.getBlockEntity(pPos);
        if (tile == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!pLevel.isClientSide && (held = pPlayer.getItemInHand(pHand)).is(ItemTagProvider.JAR_ITEM_BLACKLIST)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (tile.getEntity() == null && !pLevel.isClientSide) {
            Item item = stack.getItem();
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                EntityType type = spawnEggItem.getType(stack);
                Entity entity = type.create(pLevel);
                if (entity != null) {
                    tile.setEntityData(entity);
                    stack.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            } else if (!(stack.isEmpty() || stack.getItem() instanceof MobJarItem || pPlayer instanceof ANFakePlayer)) {
                ItemEntity entity = new ItemEntity(EntityType.ITEM, pLevel);
                entity.setItem(stack.copy());
                tile.setEntityData((Entity)entity);
                stack.setCount(0);
                return ItemInteractionResult.CONSUME;
            }
        }
        if (!(tile.getEntity() == null || tile.getEntity() instanceof PlayerRideable || JarBehaviorRegistry.containsEntity(tile.getEntity()) || tile.getEntity() instanceof ContainerEntity)) {
            Entity tileEntity = tile.getEntity();
            pPlayer.interactOn(tileEntity, pHand);
            if (!tileEntity.isAlive() || tileEntity.isRemoved()) {
                tile.removeEntity();
            }
        }
        tile.dispatchBehavior(behavior -> behavior.use(pState, pLevel, pPos, pPlayer, pHand, pHit, tile));
        tile.updateBlock();
        return ItemInteractionResult.SUCCESS;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        context.getLevel().scheduleTick(context.getClickedPos(), (Block)this, 1);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue(POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public BlockState updateShape(BlockState stateIn, Direction side, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.isClientSide) {
            return;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof MobJarTile) {
            MobJarTile tile = (MobJarTile)blockEntity;
            int light = tile.calculateLight();
            if ((Integer)pState.getValue(LIGHT_LEVEL) != light) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
            }
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag;
        if (!pLevel.isClientSide && (flag = ((Boolean)pState.getValue(POWERED)).booleanValue()) != pLevel.hasNeighborSignal(pPos)) {
            if (!flag) {
                MobJarTile tile = (MobJarTile)pLevel.getBlockEntity(pPos);
                tile.dispatchBehavior(behavior -> behavior.onRedstonePower(tile));
            }
            pLevel.setBlock(pPos, (BlockState)pState.cycle(POWERED), 2);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        MobJarTile tile = (MobJarTile)worldIn.getBlockEntity(pos);
        AtomicInteger power = new AtomicInteger();
        tile.dispatchBehavior(behavior -> power.set(Math.max(power.get(), behavior.getAnalogPower(tile))));
        return Math.min(power.get(), 15);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED, LIGHT_LEVEL, POWERED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new MobJarTile(pPos, pState);
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntity = pBlockAccess.getBlockEntity(pPos);
        if (blockEntity instanceof MobJarTile) {
            MobJarTile jarTile = (MobJarTile)blockEntity;
            AtomicInteger power = new AtomicInteger();
            jarTile.dispatchBehavior(behavior -> power.set(Math.max(power.get(), behavior.getSignalPower(jarTile))));
            return Math.min(power.get(), 15);
        }
        return 0;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

