/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.items.data.PotionJarData;
import com.hollingsworth.arsnouveau.common.util.ItemUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PotionJar
extends ModBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    VoxelShape shape = Stream.of(Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.box((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public PotionJar(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PotionJar() {
        this(ModBlock.defaultProperties().noOcclusion());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        PotionJarTile tile = (PotionJarTile)worldIn.getBlockEntity(pos);
        if (tile == null || tile.getAmount() <= 0) {
            return 0;
        }
        int step = (tile.getMaxFill() - 1) / 14;
        return (tile.getAmount() - 1) / step + 1;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
        }
        PotionJarTile tile = (PotionJarTile)worldIn.getBlockEntity(pos);
        if (tile == null) {
            return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
        }
        PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (stack.getItem() == Items.POTION && potion != null && potion != PotionContents.EMPTY) {
            if (tile.canAccept(potion, 100)) {
                tile.add(potion, 100);
                if (!player.isCreative()) {
                    stack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
            }
            return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
        }
        if (stack.getItem() == Items.GLASS_BOTTLE && tile.getAmount() >= 100) {
            ItemStack potionStack = new ItemStack((ItemLike)Items.POTION);
            PotionContents contents = tile.getData();
            potionStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(contents.potion(), contents.customColor(), contents.customEffects()));
            if (ItemUtil.shrinkHandAndAddStack(potionStack, handIn, player)) {
                tile.remove(100);
            }
        } else if (stack.getItem() == Items.ARROW && tile.getAmount() >= 10) {
            ItemStack potionStack = new ItemStack((ItemLike)Items.TIPPED_ARROW);
            PotionContents contents = tile.getData();
            potionStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(contents.potion(), contents.customColor(), contents.customEffects()));
            if (ItemUtil.shrinkHandAndAddStack(potionStack, handIn, player)) {
                tile.remove(10);
            }
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SourceJar.fill});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PotionJarTile(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        PotionJarData potion = (PotionJarData)stack.get(DataComponentRegistry.POTION_JAR);
        if (potion == null) {
            return;
        }
        int fill = potion.fill();
        PotionContents data = potion.contents();
        if (!data.equals((Object)PotionContents.EMPTY)) {
            ItemStack potionItem = new ItemStack((ItemLike)Items.POTION);
            potionItem.set(DataComponents.POTION_CONTENTS, (Object)data);
            tooltip.add((Component)Component.translatable((String)potionItem.getDescriptionId()));
        }
        PotionContents.addPotionTooltip((Iterable)data.getAllEffects(), tooltip::add, (float)1.0f, (float)20.0f);
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.source_jar.fullness", (Object[])new Object[]{fill * 100 / 10000}));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        context.getLevel().scheduleTick(context.getClickedPos(), (Block)BlockRegistry.POTION_JAR.get(), 1);
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public void tick(BlockState p_222945_, ServerLevel level, BlockPos pos, RandomSource p_222948_) {
        super.tick(p_222945_, level, pos, p_222948_);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PotionJarTile) {
            PotionJarTile jarTile = (PotionJarTile)blockEntity;
            jarTile.updateBlock();
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction side, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

