/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotatingSpellTurret
extends BasicSpellTurret {
    public static HashMap<AbstractCastMethod, ITurretBehavior> ROT_TURRET_BEHAVIOR_MAP = new HashMap();

    public static Position getDispensePosition(BlockPos coords, RotatingTurretTile tile) {
        Vec3 direction = tile.getShootAngle().normalize();
        double d0 = (double)coords.getX() + 0.5 + 0.5 * direction.x();
        double d1 = (double)coords.getY() + 0.5 + 0.5 * direction.y();
        double d2 = (double)coords.getZ() + 0.5 + 0.5 * direction.z();
        return new Vec3(d0, d1, d2);
    }

    public void setPlacedBy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.orderedByNearest((Entity)placer)[0].getOpposite();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof RotatingTurretTile)) {
            return;
        }
        RotatingTurretTile turretTile = (RotatingTurretTile)blockEntity;
        switch (orientation) {
            case DOWN: {
                turretTile.rotationY = -90.0f;
                break;
            }
            case UP: {
                turretTile.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                turretTile.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                turretTile.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                turretTile.rotationX = 180.0f;
            }
        }
    }

    @Override
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RotatingTurretTile(pos, state);
    }

    static {
        ROT_TURRET_BEHAVIOR_MAP.put(MethodProjectile.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position iposition, Direction direction) {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
                    spell.setOwner((Entity)fakePlayer);
                    spell.setPos(iposition.x(), iposition.y(), iposition.z());
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().normalize();
                    spell.shoot(vec3d.x(), vec3d.y(), vec3d.z(), 0.5f, 0.0f);
                    world.addFreshEntity((Entity)spell);
                }
            }
        });
        ROT_TURRET_BEHAVIOR_MAP.put(MethodTouch.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, ServerLevel serverLevel, BlockPos pos, Player fakePlayer, Position dispensePosition, Direction facingDir) {
                BlockPos touchPos = pos.relative(facingDir);
                BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
                if (!(blockEntity instanceof RotatingTurretTile)) {
                    return;
                }
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                Vec3 aimVec = rotatingTurretTile.getShootAngle().add(rotatingTurretTile.getX() + 0.5, rotatingTurretTile.getY() + 0.5, rotatingTurretTile.getZ() + 0.5);
                List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(touchPos));
                if (!entityList.isEmpty()) {
                    LivingEntity entity = (LivingEntity)entityList.get(serverLevel.random.nextInt(entityList.size()));
                    resolver.onCastOnEntity(ItemStack.EMPTY, (Entity)entity, InteractionHand.MAIN_HAND);
                } else {
                    resolver.onCastOnBlock(new BlockHitResult(aimVec, facingDir, BlockPos.containing((double)aimVec.x(), (double)aimVec.y(), (double)aimVec.z()), true));
                }
            }
        });
    }
}

