/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.block.IPedestalMachine;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.SingleItemTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchantingApparatusTile
extends SingleItemTile
implements Container,
IPedestalMachine,
ITickable,
GeoBlockEntity {
    private int counter;
    public boolean isCrafting;
    public static final int craftingLength = 210;
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EnchantingApparatusTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.ENCHANTING_APP_TILE.get(), pos, state);
    }

    @Override
    public void lightPedestal(Level level) {
        if (level != null) {
            for (BlockPos pos : this.pedestalList()) {
                ParticleUtil.spawnOrb(level, ParticleColor.makeRandomColor(255, 255, 255, level.random), pos.above(), 300);
            }
        }
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            if (this.isCrafting) {
                Level world = this.getLevel();
                BlockPos pos = this.getBlockPos().offset(0, 1, 0);
                RandomSource rand = world.getRandom();
                Vec3 particlePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 0.0, 0.5);
                particlePos = particlePos.add(ParticleUtil.pointInSphere());
                world.addParticle(ParticleLineData.createData(new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255))), particlePos.x(), particlePos.y(), particlePos.z(), (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
                for (BlockPos p : this.pedestalList()) {
                    ArcanePedestalTile pedestalTile;
                    BlockEntity blockEntity = this.level.getBlockEntity(p);
                    if (!(blockEntity instanceof ArcanePedestalTile) || (pedestalTile = (ArcanePedestalTile)blockEntity).getStack() == null || pedestalTile.getStack().isEmpty()) continue;
                    this.getLevel().addParticle(GlowParticleData.createData(new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255))), (double)p.getX() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), (double)p.getY() + 1.5 + ParticleUtil.inRange(-0.3, 0.3), (double)p.getZ() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (this.isCrafting) {
            if (this.getRecipe(this.stack, null) == null) {
                this.isCrafting = false;
                this.setChanged();
            }
            ++this.counter;
        }
        if (this.counter > 210) {
            this.counter = 0;
            if (this.isCrafting) {
                IEnchantingRecipe recipe = this.getRecipe(this.stack, null);
                if (recipe != null) {
                    this.stack = recipe.assemble(new ApparatusRecipeInput(this), (HolderLookup.Provider)this.level.registryAccess());
                    this.clearItems();
                    this.setChanged();
                    ParticleUtil.spawnPoof((ServerLevel)this.level, this.worldPosition);
                    this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundRegistry.APPARATUS_FINISH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.isCrafting = false;
                this.setChanged();
            }
            this.updateBlock();
        }
    }

    public void clearItems() {
        for (BlockPos blockPos : this.pedestalList()) {
            ArcanePedestalTile tile;
            BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
            if (!(blockEntity instanceof ArcanePedestalTile) || (tile = (ArcanePedestalTile)blockEntity).getStack() == null) continue;
            tile.setStack(tile.getStack().getCraftingRemainingItem());
            BlockState state = this.level.getBlockState(blockPos);
            this.level.sendBlockUpdated(blockPos, state, state, 3);
            tile.setChanged();
        }
    }

    public List<BlockPos> pedestalList() {
        return this.pedestalList(this.getBlockPos(), 3, this.getLevel());
    }

    public List<ItemStack> getPedestalItems() {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        for (BlockPos blockPos : this.pedestalList()) {
            ArcanePedestalTile tile;
            BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
            if (!(blockEntity instanceof ArcanePedestalTile) || (tile = (ArcanePedestalTile)blockEntity).getStack() == null || tile.getStack().isEmpty()) continue;
            pedestalItems.add(tile.getStack());
        }
        return pedestalItems;
    }

    public IEnchantingRecipe getRecipe(ItemStack stack, @Nullable Player playerEntity) {
        List<ItemStack> pedestalItems = this.getPedestalItems();
        RecipeHolder holder = ArsNouveauAPI.getInstance().getEnchantingApparatusRecipes(this.level).stream().filter(r -> ((IEnchantingRecipe)r.value()).matches(new ApparatusRecipeInput(stack, pedestalItems, playerEntity), this.level)).findFirst().orElse(null);
        return holder != null ? (IEnchantingRecipe)holder.value() : null;
    }

    public boolean attemptCraft(ItemStack catalyst, @Nullable Player playerEntity) {
        if (this.isCrafting) {
            return false;
        }
        if (!this.craftingPossible(catalyst, playerEntity)) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(catalyst, playerEntity);
        if (recipe.consumesSource()) {
            SourceUtil.takeSourceWithParticles(this.worldPosition, this.level, 10, recipe.sourceCost());
        }
        this.isCrafting = true;
        this.updateBlock();
        Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new PacketOneShotAnimation(this.worldPosition));
        this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundRegistry.APPARATUS_CHANNEL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public boolean craftingPossible(ItemStack stack, Player playerEntity) {
        if (this.isCrafting || stack.isEmpty()) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(stack, playerEntity);
        if (recipe == null && playerEntity != null) {
            ArrayList<ColorPos> colorPos = new ArrayList<ColorPos>();
            for (BlockPos pos : this.pedestalList()) {
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof ArcanePedestalTile)) continue;
                ArcanePedestalTile tile = (ArcanePedestalTile)blockEntity;
                colorPos.add(ColorPos.centeredAbove(tile.getBlockPos()));
            }
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new HighlightAreaPacket(colorPos, 60));
        }
        return recipe != null && (!recipe.consumesSource() || recipe.consumesSource() && SourceUtil.hasSourceNearby(this.worldPosition, this.level, 10, recipe.sourceCost()));
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.isCrafting = compound.getBoolean("is_crafting");
        this.counter = compound.getInt("counter");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putBoolean("is_crafting", this.isCrafting);
        tag.putInt("counter", this.counter);
    }

    @Override
    public ItemStack getItem(int index) {
        if (this.isCrafting) {
            return ItemStack.EMPTY;
        }
        return super.getItem(index);
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack newStack) {
        if (this.isCrafting || newStack.isEmpty()) {
            return false;
        }
        return this.stack.isEmpty() && this.craftingPossible(newStack, null);
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        if (this.isCrafting) {
            return ItemStack.EMPTY;
        }
        return super.removeItem(index, count);
    }

    @Override
    public ItemStack removeItemNoUpdate(int index) {
        if (this.isCrafting) {
            return ItemStack.EMPTY;
        }
        return super.removeItemNoUpdate(index);
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        if (this.isCrafting) {
            return;
        }
        super.setItem(index, stack);
        this.attemptCraft(stack, null);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("floating"));
            return PlayState.CONTINUE;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "craft_controller", 0, event -> {
            if (!this.isCrafting) {
                event.getController().forceAnimationReset();
                return PlayState.STOP;
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay("enchanting"));
            return PlayState.CONTINUE;
        }));
    }

    public double getBoneResetTime() {
        return 0.0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }
}

