/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.registry.JarBehaviorRegistry;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.data.MobJarData;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class MobJarTile
extends ModdedTile
implements ITickable,
IDispellable,
ITooltipProvider {
    @Nullable
    public Entity cachedEntity;
    private CompoundTag entityTag;
    private CompoundTag extraDataTag;

    public MobJarTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.MOB_JAR_TILE, pos, state);
    }

    @Override
    public void tick() {
        try {
            Mob mob;
            Entity entity;
            if (this.level.isClientSide && this.cachedEntity != null && (entity = this.cachedEntity) instanceof Mob && !((mob = (Mob)entity) instanceof Bee)) {
                mob.getLookControl().tick();
            }
            this.dispatchBehavior(behavior -> behavior.tick(this));
            this.setChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setEntityData(@NotNull Entity entity) {
        CompoundTag tag = new CompoundTag();
        if (entity.shouldBeSaved() && entity.save(tag)) {
            this.cachedEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)this.level, Function.identity());
            this.cachedEntity.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            this.cachedEntity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
            this.extraDataTag = null;
            this.entityTag = tag;
            if (!this.level.isClientSide) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MobJar.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.calculateLight())));
                this.updateBlock();
            }
            return true;
        }
        try {
            this.writeSimple(entity);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void writeSimple(Entity e) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", EntityType.getKey((EntityType)e.getType()).toString());
        if (this.level == null) {
            return;
        }
        this.cachedEntity = e.getType().create(this.level);
        assert (this.cachedEntity != null);
        this.cachedEntity.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        this.cachedEntity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
        this.extraDataTag = null;
        this.entityTag = tag;
        if (!this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MobJar.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.calculateLight())));
            this.updateBlock();
        }
    }

    public int calculateLight() {
        if (this.getEntity() == null) {
            return 0;
        }
        if (this.getEntity().isOnFire()) {
            return 15;
        }
        if (this.getEntity() instanceof LightningBolt) {
            return 15;
        }
        AtomicInteger light = new AtomicInteger();
        JarBehaviorRegistry.forEach(this.getEntity(), behavior -> light.set(Math.max(light.get(), behavior.lightLevel(this))));
        return light.get();
    }

    @Nullable
    public Entity getEntity() {
        if (this.entityTag != null && this.cachedEntity == null) {
            this.cachedEntity = MobJarTile.loadEntityFromTag(this.level, this.entityTag);
            if (this.cachedEntity == null) {
                return null;
            }
            this.cachedEntity.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            this.cachedEntity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
        }
        return this.cachedEntity;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        if (this.entityTag == null || this.level == null) {
            return false;
        }
        Entity entity = MobJarTile.loadEntityFromTag(this.level, this.entityTag);
        if (entity == null || entity.getType().is(EntityTags.JAR_RELEASE_BLACKLIST)) {
            return false;
        }
        entity.setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5);
        this.level.addFreshEntity(entity);
        this.removeEntity();
        return true;
    }

    public void removeEntity() {
        this.entityTag = null;
        this.cachedEntity = null;
        this.extraDataTag = null;
        this.updateBlock();
    }

    public CompoundTag getExtraDataTag() {
        return this.extraDataTag == null ? new CompoundTag() : this.extraDataTag;
    }

    public void setExtraDataTag(CompoundTag tag) {
        this.extraDataTag = tag;
        this.setChanged();
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.entityTag != null || this.cachedEntity != null) {
            this.cachedEntity = this.getEntity();
            if (this.cachedEntity != null) {
                tag.put("entityTag", (Tag)this.saveEntityToTag(this.cachedEntity));
                if (tag.getCompound("entityTag").contains("id")) {
                    tag.putString("entityId", tag.getCompound("entityTag").getString("id"));
                }
            }
        }
        if (this.extraDataTag != null) {
            tag.put("extraMobData", (Tag)this.extraDataTag);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("entityTag")) {
            this.entityTag = pTag.getCompound("entityTag");
            this.cachedEntity = null;
        }
        this.extraDataTag = pTag.getCompound("extraMobData");
    }

    @Override
    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        this.cachedEntity = null;
        this.entityTag = null;
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void dispatchBehavior(Consumer<JarBehavior<? extends Entity>> consumer) {
        Entity entity = this.getEntity();
        if (entity == null) {
            return;
        }
        JarBehaviorRegistry.forEach(entity, consumer);
    }

    public static Entity loadEntityFromTag(Level level, CompoundTag tag) {
        String id;
        Optional type;
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity());
        if (entity == null && (type = EntityType.byString((String)(id = tag.getString("id")))).isPresent()) {
            entity = ((EntityType)type.get()).create(level);
        }
        return entity;
    }

    public CompoundTag saveEntityToTag(Entity entity) {
        CompoundTag tag = new CompoundTag();
        if (entity != null) {
            entity.save(tag);
            if (tag.isEmpty()) {
                tag.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
            }
        }
        return tag;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        Entity entity = this.getEntity();
        if (entity != null) {
            JarBehaviorRegistry.forEach(entity, behavior -> behavior.getTooltip(this, tooltip));
        }
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        MobJarData jar = (MobJarData)pComponentInput.getOrDefault(DataComponentRegistry.MOB_JAR, (Object)new MobJarData(Optional.empty(), Optional.empty()));
        this.entityTag = jar.entityTag().orElse(null);
        this.extraDataTag = jar.extraDataTag().orElse(null);
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentRegistry.MOB_JAR, (Object)new MobJarData(this.entityTag, this.extraDataTag));
    }
}

