/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.data.PotionJarData;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PotionJarTile
extends ModdedTile
implements ITooltipProvider,
IWandable {
    public boolean isLocked;
    private PotionContents data = PotionContents.EMPTY;
    int currentFill;

    public PotionJarTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public PotionJarTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.POTION_JAR_TYPE, pos, state);
    }

    @Override
    public void onWanded(Player playerEntity) {
        if (!this.isLocked) {
            this.isLocked = true;
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.locked"));
        } else {
            this.isLocked = false;
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.unlocked"));
        }
        this.updateBlock();
    }

    @Override
    public boolean updateBlock() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        int fillState = 0;
        if (this.getAmount() > 0 && this.getAmount() < 1000) {
            fillState = 1;
        } else if (this.getAmount() != 0) {
            fillState = this.getAmount() / 1000 + 1;
        }
        this.level.setBlock(this.worldPosition, (BlockState)state.setValue(SourceJar.fill, (Comparable)Integer.valueOf(fillState)), 3);
        return super.updateBlock();
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 8);
    }

    @NotNull
    public PotionContents getData() {
        return this.data;
    }

    public int getColor() {
        return this.data.equals((Object)PotionContents.EMPTY) ? 0xF800F8 : this.data.getColor();
    }

    public boolean canAccept(PotionContents otherData, int amount) {
        if (otherData == null || !this.validContentTypeForJar(otherData)) {
            return false;
        }
        return !this.isLocked && this.getAmount() <= 0 || amount <= this.getMaxFill() - this.getAmount() && PotionUtil.arePotionContentsEqual(otherData, this.data);
    }

    public boolean validContentTypeForJar(PotionContents otherData) {
        return !otherData.is(Potions.WATER) && !otherData.is(Potions.MUNDANE);
    }

    public void add(PotionContents other, int amount) {
        if (this.currentFill == 0) {
            if (!this.data.equals((Object)other) || this.data.equals((Object)PotionContents.EMPTY)) {
                this.data = other;
            }
            this.currentFill += amount;
        } else {
            this.currentFill = Math.min(this.getAmount() + amount, this.getMaxFill());
        }
        this.currentFill = Math.min(this.currentFill, this.getMaxFill());
        this.updateBlock();
    }

    public void remove(int amount) {
        this.currentFill = Math.max(this.currentFill - amount, 0);
        if (this.currentFill == 0 && !this.isLocked) {
            this.data = PotionContents.EMPTY;
        }
        this.updateBlock();
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (!this.data.equals((Object)PotionContents.EMPTY)) {
            ItemStack potion = new ItemStack((ItemLike)Items.POTION);
            potion.set(DataComponents.POTION_CONTENTS, (Object)this.data);
            tooltip.add((Component)Component.translatable((String)potion.getDescriptionId()));
        }
        PotionContents.addPotionTooltip((Iterable)this.data.getAllEffects(), tooltip::add, (float)1.0f, (float)20.0f);
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.source_jar.fullness", (Object[])new Object[]{this.getAmount() * 100 / this.getMaxFill()}));
        if (this.isLocked) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.locked"));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        if (tag.contains("potionData")) {
            this.data = (PotionContents)ANCodecs.decode(PotionContents.CODEC, tag.get("potionData"));
        }
        this.isLocked = tag.getBoolean("locked");
        this.currentFill = tag.getInt("currentFill");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("potionData", ANCodecs.encode(PotionContents.CODEC, this.data));
        tag.putBoolean("locked", this.isLocked);
        tag.putInt("currentFill", this.currentFill);
    }

    public int getMaxFill() {
        return 10000;
    }

    public int getAmount() {
        return this.currentFill;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        PotionJarData jarContents = (PotionJarData)pComponentInput.getOrDefault(DataComponentRegistry.POTION_JAR, (Object)new PotionJarData(0, PotionContents.EMPTY, false));
        this.currentFill = jarContents.fill();
        this.data = jarContents.contents();
        this.isLocked = jarContents.locked();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentRegistry.POTION_JAR, (Object)new PotionJarData(this.currentFill, this.data, this.isLocked));
    }
}

