/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PotionMelderTile
extends ModdedTile
implements GeoBlockEntity,
ITickable,
IWandable,
ITooltipProvider {
    int timeMixing;
    boolean isMixing;
    boolean hasSource;
    public boolean isOff;
    int lastMixedColor;
    public List<BlockPos> fromJars = new ArrayList<BlockPos>();
    public BlockPos toPos;
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PotionMelderTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.POTION_MELDER_TYPE, pos, state);
    }

    @Override
    public void tick() {
        BlockEntity blockEntity;
        if (this.level.isClientSide) {
            BlockPos pos = this.getBlockPos();
            if (this.level.random.nextInt(6) == 0) {
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, (double)pos.getX() + ParticleUtil.inRange(-0.25, 0.25) + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + ParticleUtil.inRange(-0.25, 0.25), 0.0, 0.0, 0.0);
            }
        }
        int maxMergeTicks = 160;
        if (this.isOff) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        if (!this.level.isClientSide && !this.hasSource && this.level.getGameTime() % 20L == 0L && SourceUtil.takeSourceWithParticles(this.worldPosition, this.level, 5, (Integer)Config.MELDER_SOURCE_COST.get()) != null) {
            this.hasSource = true;
            this.updateBlock();
        }
        if (!(this.hasSource && this.toPos != null && this.level.isLoaded(this.toPos) && this.takeJarsValid() && (blockEntity = this.level.getBlockEntity(this.toPos)) instanceof PotionJarTile)) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        PotionJarTile combJar = (PotionJarTile)blockEntity;
        PotionJarTile tile1 = (PotionJarTile)this.level.getBlockEntity(this.fromJars.get(0));
        PotionJarTile tile2 = (PotionJarTile)this.level.getBlockEntity(this.fromJars.get(1));
        PotionContents data = this.getCombinedResult(tile1, tile2);
        if (!this.isOutputUnique(data, tile1, tile2) || this.outputHasDuplicateEffect(data)) {
            return;
        }
        if (!combJar.canAccept(data, (Integer)Config.MELDER_OUTPUT.get())) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        this.isMixing = true;
        ++this.timeMixing;
        ParticleColor color1 = ParticleColor.fromInt(tile1.getColor());
        ParticleColor color2 = ParticleColor.fromInt(tile2.getColor());
        if (this.level.isClientSide) {
            if (this.timeMixing >= 120) {
                for (int i = 0; i < 3; ++i) {
                    double d0 = (double)this.worldPosition.getX() + 0.5 + ParticleUtil.inRange(-0.25, 0.25);
                    double d1 = (double)(this.worldPosition.getY() + 1) + ParticleUtil.inRange(-0.1, 0.4);
                    double d2 = (double)this.worldPosition.getZ() + 0.5 + ParticleUtil.inRange(-0.25, 0.25);
                    this.level.addParticle(GlowParticleData.createData(ParticleColor.fromInt(PotionContents.getColor((Iterable)data.getAllEffects()))), d0, d1, d2, 0.0, (double)0.01f, 0.0);
                }
                this.lastMixedColor = PotionContents.getColor((Iterable)data.getAllEffects());
            }
            if (this.timeMixing >= 160) {
                this.timeMixing = 0;
            }
            return;
        }
        if (this.timeMixing % 20 == 0 && this.timeMixing > 0 && this.timeMixing <= 60) {
            EntityFlyingItem item = new EntityFlyingItem(this.level, tile1.getBlockPos().above(), this.worldPosition, Math.round(255.0f * color1.getRed()), Math.round(255.0f * color1.getGreen()), Math.round(255.0f * color1.getBlue())).withNoTouch();
            item.setDistanceAdjust(2.0f);
            this.level.addFreshEntity((Entity)item);
            EntityFlyingItem item2 = new EntityFlyingItem(this.level, tile2.getBlockPos().above(), this.worldPosition, Math.round(255.0f * color2.getRed()), Math.round(255.0f * color2.getGreen()), Math.round(255.0f * color2.getBlue())).withNoTouch();
            item2.setDistanceAdjust(2.0f);
            this.level.addFreshEntity((Entity)item2);
        }
        if (!this.level.isClientSide && this.timeMixing >= maxMergeTicks) {
            this.timeMixing = 0;
            this.mergePotions(combJar, tile1, tile2, data);
        }
    }

    public void mergePotions(PotionJarTile combJar, PotionJarTile take1, PotionJarTile take2, PotionContents data) {
        combJar.add(data, (Integer)Config.MELDER_OUTPUT.get());
        take1.remove((Integer)Config.MELDER_INPUT_COST.get());
        take2.remove((Integer)Config.MELDER_INPUT_COST.get());
        this.hasSource = false;
        ParticleColor color2 = ParticleColor.fromInt(combJar.getColor());
        EntityFlyingItem item2 = new EntityFlyingItem(this.level, new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5), new Vec3(combJar.getX() + 0.5, combJar.getY(), combJar.getZ() + 0.5), Math.round(255.0f * color2.getRed()), Math.round(255.0f * color2.getGreen()), Math.round(255.0f * color2.getBlue())).withNoTouch();
        item2.setDistanceAdjust(2.0f);
        this.level.addFreshEntity((Entity)item2);
        this.updateBlock();
    }

    public boolean takeJarsValid() {
        if (this.fromJars.size() < 2) {
            return false;
        }
        for (BlockPos p : this.fromJars) {
            PotionJarTile jar;
            BlockEntity te = this.level.getBlockEntity(p);
            if (this.level.isLoaded(p) && te instanceof PotionJarTile && (jar = (PotionJarTile)te).getAmount() >= (Integer)Config.MELDER_INPUT_COST.get()) continue;
            return false;
        }
        return true;
    }

    public PotionContents getCombinedResult(PotionJarTile jar1, PotionJarTile jar2) {
        return PotionUtil.merge(jar1.getData(), jar2.getData());
    }

    public boolean isOutputUnique(PotionContents mix, PotionJarTile take1, PotionJarTile take2) {
        return !PotionUtil.arePotionContentsEqual(mix, take1.getData()) && !PotionUtil.arePotionContentsEqual(mix, take2.getData());
    }

    public boolean outputHasDuplicateEffect(PotionContents mix) {
        Iterable effects = mix.getAllEffects();
        HashSet<MobEffect> effectSet = new HashSet<MobEffect>();
        for (MobEffectInstance effect : effects) {
            if (effectSet.add((MobEffect)effect.getEffect().value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.toPos = null;
        this.fromJars = new ArrayList<BlockPos>();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.cleared"));
        this.updateBlock();
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            if (!this.closeEnough(storedPos, this.worldPosition)) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.melder.too_far"));
                return;
            }
            this.toPos = storedPos;
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.melder.to_set"));
            this.updateBlock();
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            if (!this.closeEnough(storedPos, this.worldPosition)) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.melder.too_far"));
                return;
            }
            if (this.fromJars.size() >= 2) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.melder.from_capped"));
                return;
            }
            this.fromJars.add(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.melder.from_set", (Object[])new Object[]{this.fromJars.size()}));
            this.updateBlock();
        }
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.toPos != null) {
            list.add(ColorPos.centered(this.toPos, ParticleColor.TO_HIGHLIGHT));
        }
        for (BlockPos p : this.fromJars) {
            list.add(ColorPos.centered(p, ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    public boolean closeEnough(BlockPos pos1, BlockPos pos2) {
        return BlockUtil.distanceFrom(Vec3.atCenterOf((Vec3i)pos1), Vec3.atCenterOf((Vec3i)pos2)) <= 3.5;
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationState<E> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("stir"));
        return this.isMixing ? PlayState.CONTINUE : PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.fromJars = new ArrayList<BlockPos>();
        this.timeMixing = nbt.getInt("mixing");
        this.isMixing = nbt.getBoolean("isMixing");
        this.hasSource = nbt.getBoolean("hasMana");
        int counter = 0;
        while (NBTUtil.hasBlockPos(nbt, "from_" + counter)) {
            BlockPos pos = NBTUtil.getBlockPos(nbt, "from_" + counter);
            if (!this.fromJars.contains(pos)) {
                this.fromJars.add(pos);
            }
            ++counter;
        }
        this.toPos = NBTUtil.getNullablePos(nbt, "to_pos");
        this.isOff = nbt.getBoolean("off");
        this.lastMixedColor = nbt.getInt("lastMixedColor");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putInt("mixing", this.timeMixing);
        compound.putBoolean("isMixing", this.isMixing);
        compound.putBoolean("hasMana", this.hasSource);
        compound.putInt("lastMixedColor", this.lastMixedColor);
        NBTUtil.storeBlockPos(compound, "to_pos", this.toPos);
        int counter = 0;
        for (BlockPos p : this.fromJars) {
            NBTUtil.storeBlockPos(compound, "from_" + counter, p);
            ++counter;
        }
        compound.putBoolean("off", this.isOff);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        block10: {
            PotionJarTile jar2;
            PotionJarTile jar1;
            PotionJarTile combJar;
            block12: {
                block11: {
                    BlockEntity blockEntity;
                    if (!this.hasSource) {
                        tooltip.add((Component)Component.translatable((String)"ars_nouveau.apparatus.nomana").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
                    }
                    if (this.fromJars.size() < 2) {
                        tooltip.add((Component)Component.translatable((String)"ars_nouveau.melder.from_set", (Object[])new Object[]{this.fromJars.size()}).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
                    }
                    if (this.toPos == null || !this.level.isLoaded(this.toPos) || !(this.level.getBlockEntity(this.toPos) instanceof PotionJarTile)) {
                        tooltip.add((Component)Component.translatable((String)"ars_nouveau.melder.no_to_pos").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
                    }
                    if (this.toPos != null && this.fromJars.size() == 2 && this.hasSource && !this.isMixing && !this.takeJarsValid()) {
                        tooltip.add((Component)Component.translatable((String)"ars_nouveau.melder.needs_potion").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
                    }
                    if (this.fromJars.size() < 2 || this.toPos == null || !((blockEntity = this.level.getBlockEntity(this.toPos)) instanceof PotionJarTile)) break block10;
                    combJar = (PotionJarTile)blockEntity;
                    BlockEntity tile1 = this.level.getBlockEntity(this.fromJars.get(0));
                    BlockEntity tile2 = this.level.getBlockEntity(this.fromJars.get(1));
                    int inputCost = (Integer)Config.MELDER_INPUT_COST.get();
                    if (!(tile1 instanceof PotionJarTile)) break block11;
                    jar1 = (PotionJarTile)tile1;
                    if (!(tile2 instanceof PotionJarTile)) break block11;
                    jar2 = (PotionJarTile)tile2;
                    if (jar1.getAmount() >= inputCost && jar2.getAmount() >= inputCost) break block12;
                }
                return;
            }
            PotionContents data = this.getCombinedResult(jar1, jar2);
            if (!this.isOutputUnique(data, jar1, jar2)) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.melder.output_not_unique").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
                return;
            }
            if (this.outputHasDuplicateEffect(data)) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.melder.output_duplicate_effect").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
                return;
            }
            if (!combJar.canAccept(data, (Integer)Config.MELDER_OUTPUT.get())) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.melder.destination_invalid").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
        }
    }

    public int getColor() {
        return this.lastMixedColor == 0 ? new ParticleColor(200, 0, 200).getColor() : this.lastMixedColor;
    }
}

