/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.RedstoneRelay;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RedstoneRelayTile
extends ModdedTile
implements IWandable,
ITooltipProvider,
ITickable,
GeoBlockEntity {
    public List<BlockPos> poweredFrom = new ArrayList<BlockPos>();
    public List<BlockPos> powering = new ArrayList<BlockPos>();
    private int localPower;
    private int powerFromParentRelays;
    private int currentPower;
    @Nullable
    private BlockPos currentParent;
    boolean updateListeners;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RedstoneRelayTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.REDSTONE_RELAY_TILE.get(), pos, state);
    }

    public int getOutputPower() {
        return this.currentPower;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.updateListeners) {
            this.calculateNewPower();
            this.updateListeners = false;
        }
    }

    public void onParentPowerChange(BlockPos pos, int newParentPower) {
        if (!this.poweredFrom.contains(pos)) {
            this.level.updateNeighborsAt(this.worldPosition, (Block)BlockRegistry.REDSTONE_RELAY.get());
            return;
        }
        if (pos.equals((Object)this.currentParent)) {
            this.powerFromParentRelays = newParentPower;
            this.calculateNewPower();
        } else if (newParentPower > this.powerFromParentRelays) {
            this.currentParent = pos.immutable();
            this.powerFromParentRelays = newParentPower;
            this.calculateNewPower();
        }
        this.level.updateNeighborsAt(this.worldPosition, (Block)BlockRegistry.REDSTONE_RELAY.get());
    }

    public void calculateNewPower() {
        if (this.level.isClientSide) {
            return;
        }
        int oldPower = this.currentPower;
        int newPower = this.localPower;
        for (BlockPos pos : this.poweredFrom) {
            RedstoneRelayTile redstoneRelayTile;
            BlockEntity blockEntity;
            if (!this.level.isLoaded(pos) || !((blockEntity = this.level.getBlockEntity(pos)) instanceof RedstoneRelayTile) || (redstoneRelayTile = (RedstoneRelayTile)blockEntity).getOutputPower() <= this.localPower) continue;
            newPower = redstoneRelayTile.getOutputPower();
            this.currentParent = pos.immutable();
            this.powerFromParentRelays = redstoneRelayTile.getOutputPower();
        }
        if (newPower != oldPower) {
            this.setNewPower(newPower);
        }
    }

    protected void setNewPower(int power) {
        this.currentPower = power;
        RedstoneRelay cfr_ignored_0 = (RedstoneRelay)BlockRegistry.REDSTONE_RELAY.get();
        if (!this.level.getBlockState(this.worldPosition).hasProperty((Property)RedstoneRelay.POWER)) {
            return;
        }
        RedstoneRelay cfr_ignored_1 = (RedstoneRelay)BlockRegistry.REDSTONE_RELAY.get();
        this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)RedstoneRelay.POWER, (Comparable)Integer.valueOf(power)), 3);
        this.updateBlock();
        this.level.updateNeighborsAt(this.worldPosition, (Block)BlockRegistry.REDSTONE_RELAY.get());
        this.updateListeners();
    }

    @Override
    public boolean updateBlock() {
        return super.updateBlock();
    }

    public void updateListeners() {
        for (BlockPos pos : this.powering) {
            BlockEntity blockEntity;
            if (!this.level.isLoaded(pos) || !((blockEntity = this.level.getBlockEntity(pos)) instanceof RedstoneRelayTile)) continue;
            RedstoneRelayTile redstoneRelayTile = (RedstoneRelayTile)blockEntity;
            redstoneRelayTile.onParentPowerChange(this.worldPosition, this.currentPower);
        }
    }

    public void onParentRemoved(BlockPos pos) {
        this.poweredFrom.remove(pos);
        this.updateBlock();
        if (this.currentParent != null && this.currentParent.equals((Object)pos)) {
            this.calculateNewPower();
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.level.isClientSide || storedPos.equals((Object)this.getBlockPos()) || !(this.level.getBlockEntity(storedPos) instanceof RedstoneRelayTile)) {
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.worldPosition) <= (double)this.getMaxDistance()) {
            if (this.poweredFrom.contains(storedPos = storedPos.immutable())) {
                this.poweredFrom.remove(storedPos);
            } else {
                this.poweredFrom.add(storedPos);
            }
            this.updateListeners = true;
            this.updateBlock();
        }
    }

    public int getMaxDistance() {
        return 30;
    }

    @Override
    public void onFinishedConnectionFirst(@javax.annotation.Nullable BlockPos storedPos, @javax.annotation.Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.level.isClientSide || storedPos.equals((Object)this.getBlockPos()) || !(this.level.getBlockEntity(storedPos) instanceof RedstoneRelayTile)) {
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.worldPosition) <= (double)this.getMaxDistance()) {
            if (this.powering.contains(storedPos = storedPos.immutable())) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.remove", (Object[])new Object[]{DominionWand.getPosString(storedPos)}));
                this.powering.remove(storedPos);
            } else {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.send", (Object[])new Object[]{DominionWand.getPosString(storedPos)}));
                this.powering.add(storedPos);
                ParticleUtil.beam(storedPos, this.worldPosition, this.level);
            }
            this.updateListeners = true;
            this.updateBlock();
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.fail"));
        }
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.poweredFrom = new ArrayList<BlockPos>();
        this.powering = new ArrayList<BlockPos>();
        this.currentParent = null;
        ListTag listTag = pTag.getList("poweredFrom", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.getCompound(i);
            this.poweredFrom.add(BlockPos.of((long)tag.getLong("pos")));
        }
        ListTag poweringTag = pTag.getList("powering", 10);
        for (int i = 0; i < poweringTag.size(); ++i) {
            CompoundTag tag = poweringTag.getCompound(i);
            this.powering.add(BlockPos.of((long)tag.getLong("pos")));
        }
        this.localPower = pTag.getInt("localPower");
        this.currentPower = pTag.getInt("currentPower");
        this.powerFromParentRelays = pTag.getInt("powerFromParentRelays");
        if (pTag.contains("currentParent")) {
            this.currentParent = BlockPos.of((long)pTag.getLong("currentParent"));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        ListTag listTag = new ListTag();
        for (BlockPos pos : this.poweredFrom) {
            CompoundTag posTag = new CompoundTag();
            posTag.putLong("pos", pos.asLong());
            listTag.add((Object)posTag);
        }
        tag.put("poweredFrom", (Tag)listTag);
        ListTag poweringTag = new ListTag();
        for (BlockPos pos : this.powering) {
            CompoundTag posTag = new CompoundTag();
            posTag.putLong("pos", pos.asLong());
            poweringTag.add((Object)posTag);
        }
        tag.put("powering", (Tag)poweringTag);
        tag.putInt("localPower", this.localPower);
        tag.putInt("currentPower", this.currentPower);
        tag.putInt("powerFromParentRelays", this.powerFromParentRelays);
        if (this.currentParent != null) {
            tag.putLong("currentParent", this.currentParent.asLong());
        }
    }

    public int getLocalPower() {
        return this.localPower;
    }

    public void setLocalPower(int newLocalPower) {
        if (this.level.isClientSide) {
            return;
        }
        if (newLocalPower != this.localPower) {
            this.localPower = newLocalPower;
            this.calculateNewPower();
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.literal((String)("current power: " + this.currentPower)));
        if (this.powering.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.one_to", (Object[])new Object[]{this.powering.size()}));
        }
        if (this.poweredFrom.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_from"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.powered_from", (Object[])new Object[]{this.poweredFrom.size()}));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate));
        data.add(new AnimationController((GeoAnimatable)this, "float_controller", 0, this::floatPredicate));
    }

    private <P extends GeoAnimatable> PlayState idlePredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("floating"));
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState floatPredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotating"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public double getTick(Object o) {
        return 0.0;
    }
}

