/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RepositoryTile
extends RandomizableContainerBlockEntity
implements GeoBlockEntity,
ITooltipProvider {
    public static String[][] CONFIGURATIONS = new String[][]{{"1", "2_3", "4_6", "7_9", "10_12", "13_15", "16_18", "19_21", "22_24", "25_27"}, {"1", "2_3", "25_27", "22_24", "19_21", "10_12", "7_9", "4_6", "13_15", "16_18"}, {"10_12", "13_15", "7_9", "16_18", "4_6", "19_21", "2_3", "22_24", "1", "25_27"}, {"1", "2_3", "4_6", "13_15", "16_18", "25_27", "22_24", "10_12", "19_21", "7_9"}, {"1", "25_27", "2_3", "22_24", "4_6", "19_21", "7_9", "16_18", "10_12", "13_15"}, {"1", "2_3", "4_6", "10_12", "25_27", "22_24", "19_21", "13_15", "7_9", "16_18"}};
    private NonNullList<ItemStack> items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    public int fillLevel;
    public int configuration;
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
        }

        protected void onClose(Level level, BlockPos p_155073_, BlockState p_155074_) {
            RepositoryTile.this.updateFill();
        }

        protected void openerCountChanged(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean isOwnContainer(Player p_155060_) {
            if (p_155060_.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)p_155060_.containerMenu).getContainer();
                return container == RepositoryTile.this;
            }
            return false;
        }
    };
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void updateFill() {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.getContainerSize(); ++j) {
            ItemStack itemstack = this.getItem(j);
            if (itemstack.isEmpty()) continue;
            f += 1.0f;
            ++i;
        }
        int oldFill = this.fillLevel;
        this.fillLevel = Mth.floor((float)((f /= (float)this.getContainerSize()) * 14.0f)) + (i > 0 ? 1 : 0);
        if (oldFill != this.fillLevel) {
            this.updateBlock();
        }
    }

    public RepositoryTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.REPOSITORY_TILE.get(), pos, state);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItemStacks) {
        this.items = pItemStacks;
    }

    public void setItem(int pIndex, ItemStack pStack) {
        super.setItem(pIndex, pStack);
        this.updateFill();
    }

    public ItemStack removeItem(int pIndex, int pCount) {
        ItemStack stack = super.removeItem(pIndex, pCount);
        this.updateFill();
        return stack;
    }

    public void startOpen(Player pPlayer) {
        super.startOpen(pPlayer);
        this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void stopOpen(Player pPlayer) {
        super.stopOpen(pPlayer);
        this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.ars_nouveau.repository");
    }

    protected AbstractContainerMenu createMenu(int pId, Inventory pPlayer) {
        return ChestMenu.sixRows((int)pId, (Inventory)pPlayer, (Container)this);
    }

    public int getContainerSize() {
        return 54;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
        pTag.putInt("fillLevel", this.fillLevel);
        pTag.putInt("configuration", this.configuration);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
        this.fillLevel = pTag.getInt("fillLevel");
        this.configuration = pTag.getInt("configuration");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.handleUpdateTag(pkt.getTag() == null ? new CompoundTag() : pkt.getTag(), lookupProvider);
    }

    public boolean updateBlock() {
        if (this.level == null) {
            return false;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.setChanged();
        return true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.hasCustomName()) {
            tooltip.add(this.getCustomName());
        }
    }
}

