/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LevelPosMap;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.SpellSensor;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellSensorTile
extends ModdedTile
implements ITickable,
IWandable,
ITooltipProvider {
    public static LevelPosMap SENSOR_MAP = new LevelPosMap((level, pos) -> !(level.getBlockEntity(pos) instanceof SpellSensorTile));
    public int outputDuration;
    public int outputStrength;
    public boolean onCooldown;
    public int listenRange = 8;
    public boolean isOnResolve = false;
    public ItemStack parchment = ItemStack.EMPTY;

    public SpellSensorTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public SpellSensorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.SPELL_SENSOR_TILE.get(), pos, state);
    }

    public static void onSpellCast(SpellCastEvent event) {
        Vec3 vec3 = event.context.getCaster().getPosition();
        SENSOR_MAP.applyForRange(event.getWorld(), BlockPos.containing((double)vec3.x, (double)vec3.y, (double)vec3.z), 8.0, pos -> {
            BlockEntity patt0$temp = event.getWorld().getBlockEntity(pos);
            if (patt0$temp instanceof SpellSensorTile) {
                SpellSensorTile tile = (SpellSensorTile)patt0$temp;
                if (!tile.isOnResolve) {
                    tile.onSignal(event.context.getCaster().getPosition(), event.spell);
                }
            }
            return false;
        });
    }

    public static void onSpellResolve(SpellResolveEvent.Post event) {
        HitResult resolveSource = event.resolver.hitResult;
        if (resolveSource == null) {
            return;
        }
        SENSOR_MAP.applyForRange(event.world, resolveSource.getLocation(), 8.0, pos -> {
            BlockEntity patt0$temp = event.world.getBlockEntity(pos);
            if (patt0$temp instanceof SpellSensorTile) {
                SpellSensorTile tile = (SpellSensorTile)patt0$temp;
                if (tile.isOnResolve) {
                    tile.onSignal(resolveSource.getLocation(), event.spell);
                }
            }
            return false;
        });
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.isOnResolve = !this.isOnResolve;
        this.updateBlock();
    }

    public void onSignal(Vec3 pos, Spell spell) {
        if (this.onCooldown || this.outputDuration > 0) {
            return;
        }
        Vec3 thisPos = new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
        if (BlockUtil.distanceFrom(pos, thisPos) > (double)this.listenRange || SpellSensorTile.isOccluded(this.level, thisPos, pos)) {
            return;
        }
        int str = 0;
        if (!this.parchment.isEmpty()) {
            Item item = this.parchment.getItem();
            if (item instanceof SpellParchment) {
                List<AbstractSpellPart> spellParts1;
                SpellParchment spellParchment = (SpellParchment)item;
                Spell listeningSpell = SpellCasterRegistry.from(this.parchment).getSpell();
                List<AbstractSpellPart> spellParts = listeningSpell.unsafeList().stream().filter(Objects::nonNull).toList();
                if (!spellParts.equals(spellParts1 = spell.unsafeList().stream().filter(Objects::nonNull).toList())) {
                    return;
                }
            }
            str = 15;
        } else {
            str = spell.size();
        }
        this.outputDuration = 40;
        this.outputStrength = str;
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(SpellSensor.PHASE, (Comparable)SculkSensorPhase.ACTIVE));
        this.setChanged();
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
    }

    private static boolean isOccluded(Level pLevel, Vec3 pFrom, Vec3 pTo) {
        Vec3 vec3 = new Vec3((double)Mth.floor((double)pFrom.x) + 0.5, (double)Mth.floor((double)pFrom.y) + 0.5, (double)Mth.floor((double)pFrom.z) + 0.5);
        Vec3 vec31 = new Vec3((double)Mth.floor((double)pTo.x) + 0.5, (double)Mth.floor((double)pTo.y) + 0.5, (double)Mth.floor((double)pTo.z) + 0.5);
        for (Direction direction : Direction.values()) {
            Vec3 vec32 = vec3.relative(direction, (double)1.0E-5f);
            if (pLevel.isBlockInLine(new ClipBlockStateContext(vec32, vec31, p_223780_ -> p_223780_.is(BlockTagProvider.OCCLUDES_SPELL_SENSOR))).getType() == HitResult.Type.BLOCK) continue;
            return false;
        }
        return true;
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.outputDuration > 0) {
            --this.outputDuration;
            if (this.outputDuration <= 0) {
                this.outputStrength = 0;
                this.onCooldown = true;
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(SpellSensor.PHASE, (Comparable)SculkSensorPhase.INACTIVE));
                this.setChanged();
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
                this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 1);
            }
        }
        if (this.level.getGameTime() % 20L == 0L) {
            SENSOR_MAP.addPosition(this.level, this.worldPosition);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("outputDuration", this.outputDuration);
        tag.putInt("outputStrength", this.outputStrength);
        tag.putBoolean("isOnResolve", this.isOnResolve);
        tag.put("parchment", this.parchment.save(pRegistries));
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.outputDuration = pTag.getInt("outputDuration");
        this.outputStrength = pTag.getInt("outputStrength");
        this.isOnResolve = pTag.getBoolean("isOnResolve");
        this.parchment = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)pTag.getCompound("parchment"));
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        Item item;
        if (this.isOnResolve) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.sensor.on_resolve"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.sensor.on_cast"));
        }
        if (!this.parchment.isEmpty() && (item = this.parchment.getItem()) instanceof SpellParchment) {
            SpellParchment spellParchment = (SpellParchment)item;
            spellParchment.getInformation(this.parchment, Item.TooltipContext.of((Level)this.level), tooltip, (TooltipFlag)TooltipFlag.Default.NORMAL);
        }
    }
}

