/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ITextOutput;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorUpgradeRecipe
extends EnchantingApparatusRecipe
implements ITextOutput {
    public int tier;

    public ArmorUpgradeRecipe(List<Ingredient> pedestalItems, int cost, int tier) {
        super(Ingredient.EMPTY, ItemStack.EMPTY, pedestalItems, cost, false);
        this.tier = tier;
    }

    public int tier() {
        return this.tier;
    }

    @Override
    public boolean excludeJei() {
        return true;
    }

    @Override
    public boolean doesReagentMatch(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        return true;
    }

    @Override
    public boolean matches(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder(input.catalyst());
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return false;
        }
        ArmorPerkHolder armorPerkHolder = perkHolder;
        return armorPerkHolder.getTier() == this.tier - 1 && super.matches(input, level, player);
    }

    @Override
    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_346030_) {
        ItemStack reagent = input.catalyst();
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder(reagent);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return reagent.copy();
        }
        ArmorPerkHolder armorPerkHolder = perkHolder;
        reagent.set(DataComponentRegistry.ARMOR_PERKS, (Object)armorPerkHolder.setTier(this.tier));
        return reagent.copy();
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.ARMOR_UPGRADE_TYPE.get();
    }

    @Override
    public Component getOutputComponent() {
        return Component.translatable((String)"ars_nouveau.armor_upgrade.book_desc", (Object[])new Object[]{this.tier});
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.ARMOR_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<ArmorUpgradeRecipe> {
        public static MapCodec<ArmorUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost), (App)Codec.INT.fieldOf("tier").forGetter(ArmorUpgradeRecipe::tier)).apply((Applicative)instance, ArmorUpgradeRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, ArmorUpgradeRecipe> STREAM_CODEC = CheatSerializer.create(CODEC);

        @NotNull
        public MapCodec<ArmorUpgradeRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ArmorUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

