/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public record CrushRecipe(Ingredient input, List<CrushOutput> outputs, boolean skipBlockPlace) implements SpecialSingleInputRecipe
{
    public CrushRecipe(Ingredient input, List<CrushOutput> outputs) {
        this(input, outputs, false);
    }

    public List<ItemStack> getRolledOutputs(RandomSource random) {
        ArrayList<ItemStack> finalOutputs = new ArrayList<ItemStack>();
        for (CrushOutput crushRoll : this.outputs) {
            if (!(random.nextDouble() <= (double)crushRoll.chance)) continue;
            if (crushRoll.maxRange > 1) {
                int num = random.nextInt(crushRoll.maxRange) + 1;
                for (int i = 0; i < num; ++i) {
                    finalOutputs.add(crushRoll.stack.copy());
                }
                continue;
            }
            finalOutputs.add(crushRoll.stack.copy());
        }
        return finalOutputs;
    }

    public boolean shouldSkipBlockPlace() {
        return this.skipBlockPlace;
    }

    public boolean matches(SingleRecipeInput p_346065_, Level p_345375_) {
        return this.input.test(p_346065_.getItem(0));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.CRUSH_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.CRUSH_TYPE.get();
    }

    public record CrushOutput(ItemStack stack, float chance, int maxRange) {
        public static final Codec<CrushOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(CrushOutput::stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(CrushOutput::chance), (App)Codec.INT.fieldOf("maxRange").forGetter(CrushOutput::maxRange)).apply((Applicative)instance, CrushOutput::new));

        public CrushOutput(ItemStack stack, float chance) {
            this(stack, chance, 1);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrushRecipe> {
        public static final MapCodec<CrushRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(CrushRecipe::input), (App)CrushOutput.CODEC.listOf().fieldOf("output").forGetter(CrushRecipe::outputs), (App)Codec.BOOL.optionalFieldOf("skip_block_place", (Object)false).forGetter(CrushRecipe::shouldSkipBlockPlace)).apply((Applicative)instance, CrushRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrushRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buf, CrushRecipe recipe) {
            buf.writeInt(recipe.outputs.size());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.input);
            for (CrushOutput i : recipe.outputs) {
                buf.writeFloat(i.chance);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)i.stack);
                buf.writeInt(i.maxRange);
            }
            buf.writeBoolean(recipe.skipBlockPlace);
        }

        public static CrushRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ArrayList<CrushOutput> stacks = new ArrayList<CrushOutput>();
            for (int i = 0; i < length; ++i) {
                try {
                    float chance = buffer.readFloat();
                    ItemStack outStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                    int maxRange = buffer.readInt();
                    stacks.add(new CrushOutput(outStack, chance, maxRange));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            boolean skipBlockPlace = buffer.readBoolean();
            return new CrushRecipe(input, stacks, skipBlockPlace);
        }

        public MapCodec<CrushRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrushRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

