/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public record DispelEntityRecipe(EntityType<?> entity, ResourceLocation lootTable, LootItemCondition[] conditions) implements SpecialSingleInputRecipe
{
    public boolean matches(LivingEntity killer, Entity victim) {
        if (!victim.getType().equals(this.entity)) {
            return false;
        }
        if (this.conditions.length == 0) {
            return true;
        }
        LootParams params = this.getLootParams(killer, victim);
        LootContext context = new LootContext.Builder(params).create(null);
        return Arrays.stream(this.conditions).allMatch(condition -> condition.test((Object)context));
    }

    private LootParams getLootParams(LivingEntity killer, Entity victim) {
        LootParams.Builder params = new LootParams.Builder((ServerLevel)victim.level).withParameter(LootContextParams.ORIGIN, (Object)victim.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)victim).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)killer.damageSources().mobAttack(killer)).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)killer).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)killer);
        if (killer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)killer;
            params = params.withOptionalParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)serverPlayer).withLuck(serverPlayer.getLuck());
        }
        return params.create(LootContextParamSets.ENTITY);
    }

    public List<ItemStack> result(LivingEntity killer, Entity victim) {
        if (!victim.getType().equals(this.entity)) {
            return List.of();
        }
        LootParams params = this.getLootParams(killer, victim);
        LootTable lootTable = (LootTable)killer.level().registryAccess().registryOrThrow(Registries.LOOT_TABLE).get(this.lootTable());
        return lootTable.getRandomItems(params);
    }

    public boolean matches(SingleRecipeInput p_346065_, Level p_345375_) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.DISPEL_ENTITY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.DISPEL_ENTITY_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DispelEntityRecipe> {
        public static final MapCodec<DispelEntityRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(DispelEntityRecipe::entity), (App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(DispelEntityRecipe::lootTable), (App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.optionalFieldOf("loot_conditions", (Object)new LootItemCondition[0]).forGetter(DispelEntityRecipe::conditions)).apply((Applicative)instance, DispelEntityRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DispelEntityRecipe> STREAM = CheatSerializer.create(CODEC);

        public MapCodec<DispelEntityRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DispelEntityRecipe> streamCodec() {
            return STREAM;
        }
    }
}

