/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.MageBloomCrop;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.RegistryWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class DefaultTableProvider
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public DefaultTableProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(EntityLootTable::new, LootContextParamSets.ENTITY)), pRegistries);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
    }

    public static class EntityLootTable
    extends EntityLootSubProvider {
        private final Map<EntityType<?>, Map<ResourceKey<LootTable>, LootTable.Builder>> map = Maps.newHashMap();

        protected EntityLootTable(HolderLookup.Provider pRegistries) {
            super(FeatureFlags.REGISTRY.allFlags(), pRegistries);
        }

        public void generate() {
            this.add((EntityType)ModEntities.WILDEN_STALKER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.WILDEN_WING.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)ModEntities.WILDEN_GUARDIAN.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.WILDEN_SPIKE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)ModEntities.WILDEN_HUNTER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.WILDEN_HORN.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        protected void add(EntityType<?> pEntityType, LootTable.Builder pBuilder) {
            super.add(pEntityType, pBuilder);
            this.map.put(pEntityType, (Map<ResourceKey<LootTable>, LootTable.Builder>)ImmutableMap.of((Object)pEntityType.getDefaultLootTable(), (Object)pBuilder));
        }

        protected void add(EntityType<?> pEntityType, ResourceKey<LootTable> pLootTableLocation, LootTable.Builder pBuilder) {
            super.add(pEntityType, pLootTableLocation, pBuilder);
            this.map.computeIfAbsent(pEntityType, p_249004_ -> Maps.newHashMap()).put(pLootTableLocation, pBuilder);
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pGenerator) {
            this.generate();
            HashSet set = Sets.newHashSet();
            this.getKnownEntityTypes().map(EntityType::builtInRegistryHolder).forEach(p_249003_ -> {
                EntityType entitytype = (EntityType)p_249003_.value();
                if (this.canHaveLootTable(entitytype)) {
                    Map<ResourceKey<LootTable>, LootTable.Builder> map = this.map.remove(entitytype);
                    ResourceKey resourcelocation = entitytype.getDefaultLootTable();
                    if (map != null) {
                        map.forEach((p_250376_, p_250972_) -> {
                            if (!set.add(p_250376_)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", p_250376_, p_249003_.key().location()));
                            }
                            pGenerator.accept((ResourceKey<LootTable>)p_250376_, (LootTable.Builder)p_250972_);
                        });
                    }
                } else {
                    Map<ResourceKey<LootTable>, LootTable.Builder> map1 = this.map.remove(entitytype);
                    if (map1 != null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map1.keySet().stream().map(ResourceKey::toString).collect(Collectors.joining(",")), p_249003_.key().location()));
                    }
                }
            });
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return BuiltInRegistries.ENTITY_TYPE.stream().filter(block -> BuiltInRegistries.ENTITY_TYPE.getKey(block).getNamespace().equals("ars_nouveau")).toList().stream();
        }
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public List<Block> list = new ArrayList<Block>();

        protected BlockLootTable(HolderLookup.Provider pRegistries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), pRegistries);
        }

        protected void generate() {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.registerDropSelf(BlockRegistry.ENCHANTED_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.BLAZING_LOG);
            this.registerDropSelf(BlockRegistry.VEXING_LOG);
            this.registerDropSelf(BlockRegistry.CASCADING_LOG);
            this.registerDropSelf(BlockRegistry.FLOURISHING_LOG);
            this.registerDropSelf(BlockRegistry.BLAZING_SAPLING);
            this.registerDropSelf(BlockRegistry.VEXING_SAPLING);
            this.registerDropSelf(BlockRegistry.CASCADING_SAPLING);
            this.registerDropSelf(BlockRegistry.FLOURISHING_SAPLING);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_PLANK);
            this.registerDrop((Block)BlockRegistry.WIXIE_CAULDRON.get(), (ItemLike)Items.CAULDRON);
            for (FlowerPotBlock pot : BlockRegistry.flowerPots.values()) {
                this.list.add((Block)pot);
                this.dropPottedContents((Block)pot);
            }
            this.registerLeavesAndSticks((Block)BlockRegistry.BLAZING_LEAVES.get(), (Block)BlockRegistry.BLAZING_SAPLING.get());
            this.registerLeavesAndSticks((Block)BlockRegistry.CASCADING_LEAVE.get(), (Block)BlockRegistry.CASCADING_SAPLING.get());
            this.registerLeavesAndSticks((Block)BlockRegistry.FLOURISHING_LEAVES.get(), (Block)BlockRegistry.FLOURISHING_SAPLING.get());
            this.registerLeavesAndSticks((Block)BlockRegistry.VEXING_LEAVES.get(), (Block)BlockRegistry.VEXING_SAPLING.get());
            this.registerDropSelf(BlockRegistry.BLAZING_WOOD);
            this.registerDropSelf(BlockRegistry.VEXING_WOOD);
            this.registerDropSelf(BlockRegistry.CASCADING_WOOD);
            this.registerDropSelf(BlockRegistry.FLOURISHING_WOOD);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_BUTTON);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_STAIRS);
            this.registerSlabItemTable((Block)BlockRegistry.ARCHWOOD_SLABS.get());
            this.registerDropSelf(BlockRegistry.MAGELIGHT_TORCH);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_FENCE_GATE);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_TRAPDOOR);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_PPlate);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_FENCE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_BLUE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_BLUE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_GREEN);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_GREEN);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_RED);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_RED);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_PURPLE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_PURPLE);
            this.registerDropDoor((Block)BlockRegistry.ARCHWOOD_DOOR.get());
            this.registerDropSelf(BlockRegistry.SOURCE_GEM_BLOCK);
            this.registerDropSelf(BlockRegistry.POTION_MELDER);
            this.registerDropSelf(BlockRegistry.RITUAL_BLOCK);
            this.registerDropSelf(BlockRegistry.GOLD_SCONCE_BLOCK);
            this.registerBedCondition((Block)BlockRegistry.SCRIBES_BLOCK.get(), (Property)ScribesBlock.PART, (Comparable<T> & StringRepresentable)ThreePartBlock.HEAD);
            this.registerDrop((Block)BlockRegistry.DRYGMY_BLOCK.get(), (ItemLike)Items.MOSSY_COBBLESTONE);
            this.registerDropSelf(BlockRegistry.VITALIC_BLOCK);
            this.registerDropSelf(BlockRegistry.ALCHEMICAL_BLOCK);
            this.registerDropSelf(BlockRegistry.MYCELIAL_BLOCK);
            this.registerDropSelf(BlockRegistry.TIMER_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.BASIC_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_CHEST);
            this.registerDropSelf(BlockRegistry.SPELL_PRISM);
            this.registerDropSelf(BlockRegistry.AGRONOMIC_SOURCELINK);
            this.registerDropSelf(BlockRegistry.ENCHANTING_APP_BLOCK);
            LootPool.Builder pedestal = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(BlockRegistry.ARCANE_PEDESTAL).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            this.add((Block)BlockRegistry.ARCANE_PEDESTAL.get(), LootTable.lootTable().withPool(pedestal));
            LootPool.Builder platform = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(BlockRegistry.ARCANE_PLATFORM).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            this.add((Block)BlockRegistry.ARCANE_PLATFORM.get(), LootTable.lootTable().withPool(platform));
            this.registerDropSelf(BlockRegistry.RELAY);
            this.registerDropSelf(BlockRegistry.RELAY_SPLITTER);
            this.registerDropSelf(BlockRegistry.ARCANE_CORE_BLOCK);
            this.registerDropSelf(BlockRegistry.IMBUEMENT_BLOCK);
            this.registerDropSelf(BlockRegistry.VOLCANIC_BLOCK);
            this.registerDropSelf(BlockRegistry.BRAZIER_RELAY);
            this.registerDropSelf(BlockRegistry.RELAY_WARP);
            this.registerDropSelf(BlockRegistry.RELAY_DEPOSIT);
            this.registerDropSelf(BlockRegistry.RELAY_COLLECTOR);
            this.registerDropSelf((Block)BlockRegistry.CRAFTING_LECTERN.get());
            this.registerDropSelf(BlockRegistry.RED_SBED);
            this.registerDropSelf(BlockRegistry.YELLOW_SBED);
            this.registerDropSelf(BlockRegistry.GREEN_SBED);
            this.registerDropSelf(BlockRegistry.PURPLE_SBED);
            this.registerDropSelf(BlockRegistry.BLUE_SBED);
            this.registerDropSelf(BlockRegistry.ORANGE_SBED);
            this.registerDropSelf(BlockRegistry.SCRYERS_CRYSTAL);
            this.registerDropSelf(BlockRegistry.SCRYERS_OCULUS);
            this.registerDropSelf(BlockRegistry.POTION_DIFFUSER);
            for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
                this.registerDropSelf(BlockRegistry.getBlock(s));
                Block block = (Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s + "_stairs"));
                this.registerDropSelf(block);
                Block slab = (Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s + "_slab"));
                this.registerDropSelf(slab);
            }
            this.registerBedCondition((Block)BlockRegistry.ALTERATION_TABLE.get(), (Property)AlterationTable.PART, (Comparable<T> & StringRepresentable)ThreePartBlock.HEAD);
            this.registerDropSelf(BlockRegistry.VOID_PRISM);
            this.registerDropSelf(BlockRegistry.MAGEBLOOM_BLOCK);
            this.registerDropSelf(BlockRegistry.GHOST_WEAVE);
            this.registerDropSelf(BlockRegistry.FALSE_WEAVE);
            this.registerDropSelf(BlockRegistry.MIRROR_WEAVE);
            this.registerDropSelf(BlockRegistry.ITEM_DETECTOR);
            this.registerDropSelf(BlockRegistry.SKY_WEAVE);
            this.registerDropSelf(BlockRegistry.ROTATING_TURRET);
            this.registerDropSelf(BlockRegistry.SPELL_SENSOR);
            this.add((Block)BlockRegistry.SOURCE_JAR.get(), this.createManaManchineTable((Block)BlockRegistry.SOURCE_JAR.get()));
            LootPool.Builder potionJarBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(BlockRegistry.POTION_JAR).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)DataComponentRegistry.POTION_JAR.get())));
            this.add((Block)BlockRegistry.POTION_JAR.get(), LootTable.lootTable().withPool(potionJarBuilder));
            this.add((Block)BlockRegistry.BASTION_POD.get(), LootTable.lootTable().withPool(this.POD_BUILDER(BlockRegistry.BASTION_POD.asItem(), (Block)BlockRegistry.BASTION_POD.get())));
            this.add((Block)BlockRegistry.MENDOSTEEN_POD.get(), LootTable.lootTable().withPool(this.POD_BUILDER(BlockRegistry.MENDOSTEEN_POD.asItem(), (Block)BlockRegistry.MENDOSTEEN_POD.get())));
            this.add((Block)BlockRegistry.FROSTAYA_POD.get(), LootTable.lootTable().withPool(this.POD_BUILDER(BlockRegistry.FROSTAYA_POD.asItem(), (Block)BlockRegistry.FROSTAYA_POD.get())));
            this.add((Block)BlockRegistry.BOMBEGRANTE_POD.get(), LootTable.lootTable().withPool(this.POD_BUILDER(BlockRegistry.BOMBEGRANTE_POD.asItem(), (Block)BlockRegistry.BOMBEGRANTE_POD.get())));
            LootPool.Builder mobJarBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(BlockRegistry.MOB_JAR).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)DataComponentRegistry.MOB_JAR.get())));
            this.add((Block)BlockRegistry.MOB_JAR.get(), LootTable.lootTable().withPool(mobJarBuilder));
            LootPool.Builder repository = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(BlockRegistry.REPOSITORY).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            this.add((Block)BlockRegistry.REPOSITORY.get(), LootTable.lootTable().withPool(repository));
            this.registerDropSelf((Block)BlockRegistry.SOURCESTONE_SCONCE_BLOCK.get());
            this.registerDropSelf((Block)BlockRegistry.POLISHED_SCONCE_BLOCK.get());
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_SCONCE_BLOCK.get());
            this.registerDropSelf((Block)BlockRegistry.REDSTONE_RELAY.get());
            this.registerDropSelf((Block)BlockRegistry.SOURCEBERRY_SACK.get());
            LootItemBlockStatePropertyCondition.Builder lootitemcondition$builder1 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)BlockRegistry.MAGE_BLOOM_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7));
            this.add((Block)BlockRegistry.MAGE_BLOOM_CROP.get(), this.createCropDrops((Block)BlockRegistry.MAGE_BLOOM_CROP.get(), ItemsRegistry.MAGE_BLOOM.asItem(), ((MageBloomCrop)((Object)BlockRegistry.MAGE_BLOOM_CROP.get())).asItem(), (LootItemCondition.Builder)lootitemcondition$builder1, 0));
            this.add((Block)BlockRegistry.SOURCEBERRY_BUSH.get(), (Block p_249159_) -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)p_249159_, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)BlockRegistry.SOURCEBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SourceBerryBush.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)BlockRegistry.SOURCEBERRY_BUSH.asItem())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)BlockRegistry.SOURCEBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SourceBerryBush.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)BlockRegistry.SOURCEBERRY_BUSH.asItem())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
        }

        protected LootTable.Builder createCropDrops(Block pCropBlock, Item pGrownCropItem, Item pSeedsItem, LootItemCondition.Builder pDropGrownCropCondition, int bonus) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)pCropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)pGrownCropItem).when(pDropGrownCropCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSeedsItem)))).withPool(LootPool.lootPool().when(pDropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSeedsItem).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)bonus)))));
        }

        protected void add(Block pBlock, LootTable.Builder pBuilder) {
            this.list.add(pBlock);
            super.add(pBlock, pBuilder);
        }

        protected void add(Block pBlock, Function<Block, LootTable.Builder> pFactory) {
            this.list.add(pBlock);
            super.add(pBlock, pFactory);
        }

        protected void add(RegistryWrapper<Block, Block> pBlock, LootTable.Builder pBuilder) {
            this.add(pBlock.get(), pBuilder);
        }

        protected void add(RegistryWrapper<Block, Block> pBlock, Function<Block, LootTable.Builder> pFactory) {
            this.add(pBlock.get(), pFactory);
        }

        public LootPool.Builder POD_BUILDER(Item item, Block block) {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ArchfruitPod.AGE, 2)))));
        }

        public LootTable.Builder createManaManchineTable(Block block) {
            LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)DataComponentRegistry.BLOCK_FILL_CONTENTS.get())));
            return LootTable.lootTable().withPool(builder);
        }

        protected void registerSlabItemTable(Block p_124291_) {
            this.list.add(p_124291_);
            this.add(p_124291_, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_124291_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)p_124291_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_124291_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE))))))));
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pGenerator) {
            this.generate();
            HashSet<ResourceKey> set = new HashSet<ResourceKey>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceKey resourcelocation;
                if (!block.isEnabled(this.enabledFeatures) || (resourcelocation = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.map.remove(resourcelocation)) == null) continue;
                pGenerator.accept((ResourceKey<LootTable>)resourcelocation, loottable$builder);
            }
        }

        protected <T extends Comparable<T> & StringRepresentable> void registerBedCondition(Block block, Property<T> prop, T isValue) {
            this.list.add(block);
            this.add(block, LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(prop, isValue)))))));
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.add(leaves, (Block l_state) -> this.createLeavesDrops((Block)l_state, sapling, DEFAULT_SAPLING_DROP_RATES));
        }

        public void registerDropDoor(Block block) {
            this.list.add(block);
            this.add(block, this.createDoorTable(block));
        }

        private <T extends Block> void registerDropSelf(BlockRegistryWrapper<T> block) {
            this.registerDropSelf((Block)block.get());
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.dropSelf(block);
        }

        public void registerDrop(Block input, ItemLike output) {
            this.list.add(input);
            this.dropOther(input, output);
        }

        protected Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("ars_nouveau")).collect(Collectors.toList());
        }
    }
}

