/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectAnimate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBounce;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBreak;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectColdSnap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCraft;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDispel;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectEnderChest;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectEvaporate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExchange;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExplosion;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFangs;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFell;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFirework;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGrow;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarvest;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectInfuse;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectInteract;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectInvisibility;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLight;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLightning;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectName;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectOrbit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPhantomBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPickup;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPlaceBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRedstone;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectReset;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRewind;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRotate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSenseMagic;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonDecoy;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonSteed;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonUndead;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonVex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonWolves;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectToss;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWindshear;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWither;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWololo;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class GlyphRecipeProvider
extends SimpleDataProvider {
    public List<GlyphRecipe> recipes = new ArrayList<GlyphRecipe>();

    public GlyphRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.add(this.get(AugmentAccelerate.INSTANCE).withItem((ItemLike)Items.POWERED_RAIL).withItem((ItemLike)Items.SUGAR).withItem((ItemLike)Items.CLOCK));
        this.add(this.get(AugmentDecelerate.INSTANCE).withItem((ItemLike)Items.SOUL_SAND).withItem((ItemLike)Items.COBWEB).withItem((ItemLike)Items.CLOCK));
        this.add(this.get(AugmentAmplify.INSTANCE).withItem((ItemLike)Items.DIAMOND_PICKAXE));
        this.add(this.get(AugmentAOE.INSTANCE).withItem((ItemLike)Items.FIREWORK_STAR));
        this.add(this.get(AugmentDampen.INSTANCE).withItem((ItemLike)Items.NETHER_BRICK));
        this.add(this.get(AugmentDurationDown.INSTANCE).withItem((ItemLike)Items.CLOCK).withItem((ItemLike)Items.GLOWSTONE_DUST));
        this.add(this.get(AugmentExtendTime.INSTANCE).withItem((ItemLike)Items.CLOCK).withIngredient(Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)));
        this.add(this.get(AugmentExtract.INSTANCE).withItem((ItemLike)Items.EMERALD));
        this.add(this.get(AugmentFortune.INSTANCE).withItem((ItemLike)Items.RABBIT_FOOT));
        this.add(this.get(AugmentPierce.INSTANCE).withItem((ItemLike)Items.ARROW).withItem(ItemsRegistry.WILDEN_SPIKE));
        this.add(this.get(AugmentSensitive.INSTANCE).withItem((ItemLike)Items.SCAFFOLDING).withItem((ItemLike)Items.POPPY).withItem((ItemLike)Items.WATER_BUCKET));
        this.add(this.get(AugmentSplit.INSTANCE).withItem(BlockRegistry.RELAY_SPLITTER).withItem(ItemsRegistry.WILDEN_SPIKE).withItem((ItemLike)Items.STONECUTTER));
        this.add(this.get(EffectOrbit.INSTANCE).withItem((ItemLike)Items.COMPASS).withItem((ItemLike)Items.ENDER_EYE).withIngredient(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE)));
        this.add(this.get(MethodProjectile.INSTANCE).withItem((ItemLike)Items.FLETCHING_TABLE).withItem((ItemLike)Items.ARROW));
        this.add(this.get(MethodSelf.INSTANCE).withIngredient(Ingredient.of((TagKey)ItemTags.WOODEN_PRESSURE_PLATES)).withItem((ItemLike)Items.IRON_CHESTPLATE));
        this.add(this.get(MethodTouch.INSTANCE).withIngredient(Ingredient.of((TagKey)ItemTags.BUTTONS)));
        this.add(this.get(MethodUnderfoot.INSTANCE).withItem((ItemLike)Items.IRON_BOOTS).withIngredient(Ingredient.of((TagKey)ItemTags.WOODEN_PRESSURE_PLATES)));
        this.add(this.get(EffectBlink.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withIngredient(Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), 4));
        this.add(this.get(EffectBounce.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withIngredient(Ingredient.of((TagKey)Tags.Items.SLIME_BALLS), 3));
        this.add(this.get(EffectBreak.INSTANCE).withItem((ItemLike)Items.IRON_PICKAXE));
        this.add(this.get(EffectColdSnap.INSTANCE).withItem(ItemsRegistry.WATER_ESSENCE).withItem((ItemLike)Items.POWDER_SNOW_BUCKET).withItem((ItemLike)Items.ICE));
        this.add(this.get(EffectConjureWater.INSTANCE).withItem(ItemsRegistry.WATER_ESSENCE).withItem((ItemLike)Items.WATER_BUCKET));
        this.add(this.get(EffectCraft.INSTANCE).withItem((ItemLike)Items.CRAFTING_TABLE));
        this.add(this.get(EffectCrush.INSTANCE).withItem(ItemsRegistry.EARTH_ESSENCE).withItem((ItemLike)Items.GRINDSTONE).withItem((ItemLike)Items.PISTON));
        this.add(this.get(EffectCut.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.SHEARS).withItem((ItemLike)Items.IRON_SWORD));
        this.add(this.get(EffectDelay.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.REPEATER).withItem((ItemLike)Items.CLOCK));
        this.add(this.get(EffectDispel.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem((ItemLike)Items.MILK_BUCKET, 3));
        this.add(this.get(EffectEnderChest.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.ENDER_CHEST));
        this.add(this.get(EffectEvaporate.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.SPONGE, 3));
        this.add(this.get(EffectExchange.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.EMERALD_BLOCK).withIngredient(Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), 2));
        this.add(this.get(EffectExplosion.INSTANCE).withItem(ItemsRegistry.FIRE_ESSENCE).withItem((ItemLike)Items.TNT, 3).withItem((ItemLike)Items.FIRE_CHARGE));
        this.add(this.get(EffectFangs.INSTANCE).withItem(ItemsRegistry.CONJURATION_ESSENCE).withItem((ItemLike)Items.PRISMARINE_SHARD, 2).withItem((ItemLike)Items.TOTEM_OF_UNDYING));
        this.add(this.get(EffectFell.INSTANCE).withItem(ItemsRegistry.EARTH_ESSENCE).withItem((ItemLike)Items.DIAMOND_AXE));
        this.add(this.get(EffectFirework.INSTANCE).withItem(ItemsRegistry.FIRE_ESSENCE).withItem((ItemLike)Items.FIREWORK_ROCKET, 2).withItem((ItemLike)Items.FIREWORK_STAR));
        this.add(this.get(EffectFlare.INSTANCE).withItem(ItemsRegistry.FIRE_ESSENCE).withItem((ItemLike)Items.FLINT_AND_STEEL, 2).withItem((ItemLike)Items.FIRE_CHARGE, 2).withItem((ItemLike)Items.BLAZE_ROD));
        this.add(this.get(EffectFreeze.INSTANCE).withItem(ItemsRegistry.WATER_ESSENCE).withItem((ItemLike)Items.SNOW_BLOCK, 2));
        this.add(this.get(EffectGlide.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem((ItemLike)Items.ELYTRA).withIngredient(Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), 3));
        this.add(this.get(EffectGravity.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem((ItemLike)Items.ANVIL, 2).withIngredient(Ingredient.of((TagKey)Tags.Items.FEATHERS), 3));
        this.add(this.get(EffectGrow.INSTANCE).withItem(ItemsRegistry.EARTH_ESSENCE).withItem((ItemLike)Items.BONE_BLOCK, 5).withIngredient(Ingredient.of((TagKey)Tags.Items.SEEDS), 3));
        this.add(this.get(EffectHarm.INSTANCE).withItem(ItemsRegistry.EARTH_ESSENCE).withItem((ItemLike)Items.IRON_SWORD, 3));
        this.add(this.get(EffectHarvest.INSTANCE).withItem(ItemsRegistry.EARTH_ESSENCE).withItem((ItemLike)Items.IRON_HOE, 1));
        this.add(this.get(EffectHeal.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem((ItemLike)Items.GLISTERING_MELON_SLICE, 4).withItem((ItemLike)Items.GOLDEN_APPLE));
        this.add(this.get(EffectHex.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem((ItemLike)Items.FERMENTED_SPIDER_EYE).withItem((ItemLike)Items.BLAZE_ROD, 3).withItem((ItemLike)Items.WITHER_ROSE));
        this.add(this.get(EffectIgnite.INSTANCE).withItem((ItemLike)Items.FLINT_AND_STEEL).withIngredient((TagKey<Item>)ItemTags.COALS, 3));
        this.add(this.get(EffectIntangible.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.PHANTOM_MEMBRANE, 3).withIngredient(Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), 2));
        this.add(this.get(EffectInteract.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.LEVER).withIngredient(Ingredient.of((TagKey)ItemTags.WOODEN_PRESSURE_PLATES)).withIngredient(Ingredient.of((TagKey)ItemTags.BUTTONS)));
        this.add(this.get(EffectInvisibility.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem((ItemLike)Items.FERMENTED_SPIDER_EYE).withIngredient(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE)));
        this.add(this.get(EffectKnockback.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem((ItemLike)Items.PISTON, 3));
        this.add(this.get(EffectLaunch.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem((ItemLike)Items.RABBIT_HIDE, 3));
        this.add(this.get(EffectLeap.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem(ItemsRegistry.WILDEN_WING, 3));
        this.add(this.get(EffectLight.INSTANCE).withItem((ItemLike)Items.LANTERN).withItem((ItemLike)Items.TORCH));
        this.add(this.get(EffectLightning.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem((ItemLike)Items.LIGHTNING_ROD, 3).withItem((ItemLike)Items.HEART_OF_THE_SEA));
        this.add(this.get(EffectLinger.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.DRAGON_BREATH).withIngredient(Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND)).withIngredient(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), 2));
        this.add(this.get(EffectPhantomBlock.INSTANCE).withIngredient((TagKey<Item>)Tags.Items.GLASS_BLOCKS, 8));
        this.add(this.get(EffectPickup.INSTANCE).withItem((ItemLike)Items.HOPPER, 2));
        this.add(this.get(EffectPull.INSTANCE).withItem((ItemLike)Items.FISHING_ROD, 1));
        this.add(this.get(EffectRedstone.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, 3));
        this.add(this.get(EffectRune.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem(ItemsRegistry.RUNIC_CHALK).withItem((ItemLike)Items.TRIPWIRE_HOOK));
        this.add(this.get(EffectSlowfall.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem(ItemsRegistry.WILDEN_WING).withItem((ItemLike)Items.FEATHER, 3).withIngredient((TagKey<Item>)Tags.Items.RODS_BLAZE, 1).withIngredient((TagKey<Item>)Tags.Items.CROPS_NETHER_WART, 1));
        this.add(this.get(EffectSmelt.INSTANCE).withItem(ItemsRegistry.FIRE_ESSENCE).withItem((ItemLike)Items.BLAST_FURNACE, 4).withIngredient((TagKey<Item>)Tags.Items.RODS_BLAZE, 1));
        this.add(this.get(EffectSnare.INSTANCE).withItem(ItemsRegistry.EARTH_ESSENCE).withItem((ItemLike)Items.COBWEB, 4));
        this.add(this.get(EffectSummonDecoy.INSTANCE).withItem(ItemsRegistry.CONJURATION_ESSENCE).withItem((ItemLike)Items.ARMOR_STAND, 4));
        this.add(this.get(EffectSummonSteed.INSTANCE).withItem((ItemLike)Items.LEATHER, 4));
        this.add(this.get(EffectSummonVex.INSTANCE).withItem(ItemsRegistry.CONJURATION_ESSENCE).withItem((ItemLike)Items.TOTEM_OF_UNDYING, 1));
        this.add(this.get(EffectSummonWolves.INSTANCE).withItem(ItemsRegistry.CONJURATION_ESSENCE).withItem((ItemLike)Items.BONE, 3).withItem(ItemsRegistry.WILDEN_WING, 4));
        this.add(this.get(EffectToss.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.DROPPER, 1));
        this.add(this.get(EffectWindshear.INSTANCE).withItem(ItemsRegistry.AIR_ESSENCE).withItem((ItemLike)Items.IRON_SWORD, 3));
        this.add(this.get(EffectWither.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem((ItemLike)Items.WITHER_SKELETON_SKULL, 3));
        this.add(this.get(EffectPlaceBlock.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.DISPENSER));
        this.add(this.get(EffectSummonUndead.INSTANCE).withItem(ItemsRegistry.CONJURATION_ESSENCE).withItem((ItemLike)Items.BONE, 1).withItem((ItemLike)Items.WITHER_SKELETON_SKULL));
        this.add(this.get(EffectName.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.NAME_TAG));
        this.add(this.get(EffectSenseMagic.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem(ItemsRegistry.DOWSING_ROD).withItem(ItemsRegistry.STARBUNCLE_SHARD));
        this.add(this.get(EffectInfuse.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withItem((ItemLike)Items.GLASS_BOTTLE).withIngredient((TagKey<Item>)Tags.Items.RODS_BLAZE, 1));
        this.add(this.get(EffectWall.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.DRAGON_BREATH).withIngredient(Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND)).withIngredient(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), 2));
        this.add(this.get(EffectRotate.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE));
        this.add(this.get(EffectAnimate.INSTANCE).withItem(ItemsRegistry.CONJURATION_ESSENCE).withIngredient((TagKey<Item>)Tags.Items.OBSIDIANS, 3));
        this.add(this.get(EffectBurst.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.TNT, 5).withItem((ItemLike)Items.FIREWORK_STAR));
        this.add(this.get(AugmentRandomize.INSTANCE).withItem((ItemLike)Items.PINK_CARPET, 2));
        this.add(this.get(EffectReset.INSTANCE).withItem((ItemLike)Items.TARGET, 1));
        this.add(this.get(EffectWololo.INSTANCE).withItem(ItemsRegistry.ABJURATION_ESSENCE).withIngredient(Ingredient.of((TagKey)Tags.Items.DYES), 3));
        this.add(this.get(EffectRewind.INSTANCE).withItem(ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.CLOCK, 3));
        for (GlyphRecipe recipe : this.recipes) {
            Path path = GlyphRecipeProvider.getScribeGlyphPath(this.output, recipe.output.getItem());
            this.saveStable(pOutput, (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
        }
    }

    public void add(GlyphRecipe recipe) {
        this.recipes.add(recipe);
    }

    public GlyphRecipe get(AbstractSpellPart spellPart) {
        return new GlyphRecipe(spellPart.glyphItem.getDefaultInstance(), new ArrayList<Ingredient>(), this.getExpFromTier(spellPart));
    }

    public int getExpFromTier(AbstractSpellPart spellPart) {
        return switch (spellPart.defaultTier().value) {
            case 1 -> 27;
            case 2 -> 55;
            case 3 -> 160;
            default -> 0;
        };
    }

    protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
        return pathIn.resolve("data/ars_nouveau/recipe/" + RegistryHelper.getRegistryName(glyph).getPath() + ".json");
    }

    @NotNull
    public String getName() {
        return "Glyph Recipes";
    }
}

